<%--
  -- Page:        editRecActions.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Displays list of actions and SQL statements associated with 1 recommendation (drilldown)
  --              or all selected recommendations (View Recommendation Details)
  --
  --  MODIFIED    (MM/DD/YY)
  --     misun     03/06/07 - fix SQL Access Advisor UI Exit Review bugs.
  --     misun     01/05/07 - XbranchMerge misun_bug-5675432 from main
  --     misun     12/14/06 - fix bug 5675432
  --     misun     08/03/06 - Add Partition Key and SQL Partiton Column
  --     mpawelko  05/13/05 - fix oac violations 
  --     mpawelko  03/28/05 - final 10.2 gui review changes 
  --     mpawelko  10/16/04 - convert actions table to uix:table 
  --     mpawelko  10/14/04 - convert sql statements table to uix:table 
  --     mpawelko  10/11/04 - add Return button if not editable 
  --     mpawelko  10/05/04 - try to fix focus problem of LOV beans 
  --     mpawelko  09/07/04 - add icon legend for status column 
  --     glavash   03/03/03 - created 
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>  
  <%@ include file="/enablePPR.jspf" %> 

  <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body>

<%-- HTML Form --%>
<db:form name="access" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,advisoryCentralUrl,dbPageNum" >
<uix:formValue name="pageName" value="/database/sqlaccess/editRecActions" />

<uix:pageLayout titleBinding = "editRecActionsHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" 
                  mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" 
                  mainTextKey="mainText"/>

 <uix:pageStatus>
    <uix:styledText textBinding="EDITACT_DESC@AAMsgs"
                    styleClass="OraFieldText" />
 </uix:pageStatus>
 
 <uix:header textBinding="ACTIONS@AAMsgs"> 
   <uix:stackLayout>

   <%-- Set all schemas in actions table to same value --%>
   <uix:rowLayout renderedBinding="canSetActionsSchema@objectBean@servletRequest" >
     <uix:cellFormat>
       <uix:messageLovField id="actionsSchema" 
                            name="actionsSchema" 
                            promptBinding="ALL_SCHEMAS@AAMsgs"
                            textBinding="actionsSchema@objectBean@servletRequest"
                            columns="25"
                            searchDescBinding="SEL_SCHEMA_TIP@AAMsgs"
                            onClick = "startLov('actionsSchema', 'ListSchema');return false" />
     </uix:cellFormat>
     <uix:spacer width="5"/>
     <uix:cellFormat>   
       <uix:submitButton textBinding="GO@AAMsgs" 
                         name="event" 
                         value="setActionsSchema"  
                         shortDescBinding="ALL_SCHEMAS@AAMsgs"/>
     </uix:cellFormat>
   </uix:rowLayout> 

   <%-- Add some vertical space between 2 LOV fields --%>
   <uix:stackLayout renderedBinding="canSetActionsSchema@objectBean@servletRequest">
     <uix:spacer height="5"/>
   </uix:stackLayout>

   <%-- Set all tablespaces in actions table to same value --%>
   <uix:rowLayout renderedBinding="canSetActionsTablespace@objectBean@servletRequest" >
     <uix:cellFormat>
       <uix:messageLovField id="actionsTablespace" 
                            name="actionsTablespace" 
                            promptBinding="ALL_TABLESPACES@AAMsgs"
                            textBinding="actionsTablespace@objectBean@servletRequest"
                            columns="25"
                            searchDescBinding="SEL_TABLESPACE_TIP@AAMsgs"
                            onClick = "startLov('actionsTablespace', 'ListTablespacePerm');return false" />
     </uix:cellFormat>
     <uix:spacer width="5"/>
     <uix:cellFormat>
       <uix:submitButton textBinding="GO@AAMsgs" 
                         name="event" 
                         value="setActionsTablespace"  
                         shortDescBinding="ALL_TABLESPACES@AAMsgs"/>
     </uix:cellFormat>
   </uix:rowLayout>

   <uix:spacer height="5"/> 

           <uix:dataScope currentDataBinding="accessRecActionsTableUI@objectBean@servletRequest"> 
             <uix:table id="accessRecActionsTableUI"
                        formSubmitted="true"
                        width="100%"
                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                        summaryBinding="ACTIONS@AAMsgs"
                        minValue="1"
                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                        showAll="yes"
                        partialRenderMode="self"
                        alternateTextBinding="NO_RECOMMENDATIONS@AAMsgs"
                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" >
   
               <uix:tableFormat tableBanding="rowBanding"/>

               <%-- Status column --%>
               <uix:column renderedBinding="is10gR2OrHigher@objectBean@servletRequest">
                 <uix:columnHeader>
                   <uix:sortableHeader textBinding="STATUS@AAMsgs"
                                       sortableBinding="<%= AccessParameterConstants.S_SORT_STATUS %>"/>
                 </uix:columnHeader> 
                 <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
                 <uix:image sourceBinding="<%= AccessParameterConstants.S_STATUS_COL %>" 
                            shortDescBinding="<%= AccessParameterConstants.S_STATUS_DESC %>" /> 
               </uix:column>

              <%-- List of Recommendation ID column (View Recommendation Details only) --%>
              <uix:column renderedBinding="<%= AccessParameterConstants.S_ALLRECS_FLAG %>" >
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="REC_IDS@AAMsgs"
                                      sortableBinding="<%= AccessParameterConstants.S_SORT_RECID %>"/>
                </uix:columnHeader> 
                <uix:columnFormat columnDataFormat="numberFormat"/>
                <uix:styledText textBinding="<%= AccessParameterConstants.S_RECID_COL %>" />
              </uix:column>

              <%-- Action column (link to full SQL text) --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="ACTION@AAMsgs"
                                      sortableBinding="<%= AccessParameterConstants.S_SORT_ACTION %>"/>
                </uix:columnHeader> 
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:link textBinding="<%= AccessParameterConstants.S_ACTION_COL %>"	
                          onClickBinding="<%= AccessParameterConstants.S_ACTION_CLICK %>" />
              </uix:column>

             <%-- Object Name column --%>
             <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="NAME@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_NAME %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_NAME_COL %>"
                              renderedBinding="<%= AccessParameterConstants.S_NAME_READONLY %>" />

              <uix:textInput name="<%= AccessParameterConstants.S_NAME_COL %>"
                             renderedBinding="<%= AccessParameterConstants.S_NAME_EDITABLE %>" 
                             shortDescBinding="<%= AccessParameterConstants.S_NAME_COL %>" 
                             textBinding="<%= AccessParameterConstants.S_NAME_COL %>" />
            </uix:column>

            <%-- Object Attributes column --%>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="OBJ_TYPE@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_TYPE %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_TYPE_COL %>" />
            </uix:column>

           <%-- Index Columns column --%>
            <uix:column renderedBinding="<%= AccessParameterConstants.S_HAVE_INDEX_FLAG %>" >
              <uix:columnHeader>
                <uix:sortableHeader textBinding="INDEX_COLS@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_INDEX_COLS %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_INDEX_COLS_COL %>" />
            </uix:column>

            <%-- Base Table column --%>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="OBJ_TABLE@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_TABLE %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_TABLE_COL %>" />
            </uix:column>

            <%-- Schema column --%>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="OPT_SCHEMA@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_OWNER %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_OWNER_COL %>" 
                              renderedBinding="<%= AccessParameterConstants.S_OWNER_READONLY %>" />

              <uix:lovField name="<%= AccessParameterConstants.S_OWNER_COL %>"
                            searchDescBinding="SEL_SCHEMA_TIP@AAMsgs"
                            shortDescBinding="OPT_SCHEMA@AAMsgs"
                            textBinding="<%= AccessParameterConstants.S_OWNER_COL %>"
                            renderedBinding="<%= AccessParameterConstants.S_OWNER_EDITABLE %>"
                            onClickBinding="<%= AccessParameterConstants.S_SCHEMA_LOV %>" />
            </uix:column>

            <%-- Tablespace column --%>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="OPT_TBLSPACE@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_TABLESPACE %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_TABLESPACE_COL %>" 
                              renderedBinding="<%= AccessParameterConstants.S_TABLESPACE_READONLY %>" />

              <uix:lovField name="<%= AccessParameterConstants.S_TABLESPACE_COL %>"
                            searchDescBinding="SEL_TABLESPACE_TIP@AAMsgs"
                            shortDescBinding="OPT_TBLSPACE@AAMsgs"
                            textBinding="<%= AccessParameterConstants.S_TABLESPACE_COL %>"
                            renderedBinding="<%= AccessParameterConstants.S_TABLESPACE_EDITABLE %>"
                            onClickBinding="<%= AccessParameterConstants.S_TABLESPACE_LOV %>" />
            </uix:column>

            <%-- Partition Key column --%>
            <uix:column renderedBinding="<%= AccessParameterConstants.S_HAVE_PARTITION_KEY %>" >
              <uix:columnHeader>
                <uix:sortableHeader textBinding="PARTITION_KEY@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_PARTITION_KEY %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_PARTITION_KEY_COL %>" />
            </uix:column>
            
            <%-- SQL Partition column --%>
            <uix:column renderedBinding="<%= AccessParameterConstants.S_HAVE_SQL_PARTITION %>" >
              <uix:columnHeader>
                <uix:sortableHeader textBinding="SQL_PARTITION@AAMsgs"
                                    sortableBinding="<%= AccessParameterConstants.S_SORT_SQL_PARTITION %>"/>
              </uix:columnHeader> 
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText textBinding="<%= AccessParameterConstants.S_SQL_PARTITION_COL %>" />
            </uix:column>

           <%-- Estimated Space Used column --%>
           <uix:column>
             <uix:columnHeader>
               <uix:sortableHeader textBinding="SPACE_USAGE@AAMsgs"
                    sortableBinding="<%= AccessParameterConstants.S_SORT_SPACE %>"/>
             </uix:columnHeader> 
             <uix:columnFormat columnDataFormat="numberFormat"/>
             <uix:styledText textBinding="<%= AccessParameterConstants.S_SPACE_COL %>" /> 
           </uix:column>

         </uix:table>
       </uix:dataScope>
     </uix:stackLayout> 
   </uix:header>   

   <uix:stackLayout renderedBinding="haveSQLStatements@objectBean@servletRequest" >
   <uix:spacer height="5"/> 
   <uix:header textBinding="editRecSQLHeader@objectBean@servletRequest">  
   <uix:spacer height="5"/>

   <uix:dataScope currentDataBinding="accessRecStmtsTableUI@objectBean@servletRequest"> 
      <uix:table id="accessRecStmtsTableUI"
                 formSubmitted="true"
                 width="100%"
                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                 summaryBinding="AFFECTED_SQL2@AAMsgs"
                 minValue="1"
                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                 showAll="yes"
                 partialRenderMode="self"
                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" >

         <uix:tableFormat tableBanding="rowBanding"/>

         <%-- Statement ID column (link to full SQL text) --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="STMT_ID@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_SQLID %>"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:link textBinding="<%= AccessParameterConstants.S_SQLID_COL %>"	
                     onClickBinding="<%= AccessParameterConstants.S_SQLID_CLICK %>" />
         </uix:column>

         <%-- SQL Statement column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="STATEMENT@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_SQL_TEXT %>"/>

           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="textFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_SQL_TEXT_COL %>" /> 
         </uix:column>

         <%-- Recommendation ID column (link to Actions drilldown) --%>
         <uix:column renderedBinding="<%= AccessParameterConstants.S_ALLRECS_FLAG %>" >
           <uix:columnHeader>
             <uix:sortableHeader textBinding="REC_ID@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_RECID %>"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_RECID_COL %>" />
         </uix:column>

         <%-- Orignal Cost column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="ORIG_COST@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_ORIG_COST %>"/>

           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_ORIG_COST_COL %>" /> 
         </uix:column>

        <%-- New Cost column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="NEW_COST@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_NEW_COST %>"/>

           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_NEW_COST_COL %>" /> 
         </uix:column>

         <%-- Cost Improvement column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="COST_IMPR@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_COST_IMPR %>"/>

           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_COST_IMPR_COL %>" /> 
         </uix:column>

         <%-- Cost Improvement (%) column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="COST_IMPR_PERC@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_COST_IMPR_PERC %>"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_COST_IMPR_PERC_COL %>" /> 
         </uix:column>

         <%-- Execution Count column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="EXEC_COUNT@AAMsgs"
                  sortableBinding="<%= AccessParameterConstants.S_SORT_EXEC %>"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="numberFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_EXEC_COL %>" /> 
         </uix:column>
       </uix:table>
     </uix:dataScope>
   </uix:header>
   </uix:stackLayout> 

<uix:pageButtons>
 <uix:pageButtonBar>
   <%-- Without spacer, buttons display right against pageStatus text - Cabo bug? --%>
   <uix:spacer width="1" />
   <%-- Can edit, display Apply/Cancel/OK buttons --%>
   <%--uix:submitButton name="event"
                     value="editRecActionsApply"
                     renderedBinding="actionsAreEditable@objectBean@servletRequest"
                     textBinding="APPLY@AAMsgs" /--%>
   <uix:submitButton name="event"
                     value="editRecActionsCancel"
                     renderedBinding="actionsAreEditable@objectBean@servletRequest"
                     textBinding="CANCEL@AAMsgs" />
   <uix:submitButton name="event"
                     value = "editRecActionsOK"
                     renderedBinding="actionsAreEditable@objectBean@servletRequest"
                     textBinding="OK@AAMsgs"/>
   <%-- Can't edit or nothing to edit, just display Done button --%>
   <uix:submitButton name="event"
                     value="editRecActionsCancel"
                     renderedBinding="actionsAreNotEditable@objectBean@servletRequest"
                     textBinding="RETURN@AAMsgs" />

 </uix:pageButtonBar>
</uix:pageButtons> 
</uix:pageLayout>

</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
