<%--
  -- Page:        implement.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Schedule Implementation page for implementing recommendations (view task results)
  --
  --  MODIFIED    (MM/DD/YY)
  --     misun     04/02/07 - partition recommendations have to be manully
  --                          implemented.
  --     mpawelko  09/30/04 - message file cleanup 
  --     mpawelko  09/08/04 - add checkbox for Stop On Error (imp_exit_on_error)
  --     glavash   03/03/03 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
<%-- bundle, ScheduleBundle, and DBScheduleBundle required by include --%>
<uix:bundle name="bundle"                   
          class="oracle.sysman.db.rsc.inst.JobsMsg"/>
<uix:bundle name="ScheduleBundle"                   
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>  

  <uix:metaContainer>
      <db:script src="/database/utils.js"/>
      <script>
      function myCallBack(lovwin, event)
      {          
      }
      </script>
    </uix:metaContainer>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

<%-- HTML Form --%>
<db:form name="scheduleForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,advisoryCentralUrl,dbPageNum" >
<uix:formValue name="pageName" value="/database/sqlaccess/implement"/>

<uix:pageLayout titleBinding="IMPLEMENT@AAMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
        <%-- Show waning if there is a partition recommendation --%>
        <uix:flowLayout renderedBinding = "partitionRecommendation@objectBean@servletRequest">
            <uix:image id="warningIcon" shortDescBinding="STOP@AAMsgs"
                sourceBinding="warningIcon@objectBean@servletRequest" />
            <uix:spacer width="5"/>
            <uix:styledText textBinding= "IMPLEMENT_PARTITIONING_STOP_ERROR@AAMsgs" 
                styleClass="OraInstructionTextStrong" />
        </uix:flowLayout>
     
           <%-- Warning/Error display --%>
            <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           
 <uix:spacer height="1"/>

 <uix:pageStatus>
   <uix:styledText textBinding="IMPL_TEXT1@AAMsgs"
                   styleClass="OraFieldText" />
 </uix:pageStatus>

 <uix:stackLayout>
   <uix:spacer height="10"/>

   <uix:rowLayout>
       <uix:messageTextInput name="implJobName" 
                      promptBinding="IMPL_JOBID@AAMsgs"
                      required="yes"
                      id="IMPL_JOBID"
                      shortDescBinding="IMPL_JOBID@AAMsgs"
                      textBinding="implJobName@objectBean@servletRequest"
                      columns="30" />
   </uix:rowLayout>

   <%-- If 10gR2+, allow user to specify whether to continue or exit if errors occur --%>
   <uix:rowLayout>
     <uix:checkBox name="impExitOnError"
                   checkedBinding="impExitOnError@objectBean@servletRequest" 
                   renderedBinding="is10gR2OrHigher@objectBean@servletRequest"
                   shortDescBinding="IMPLEMENT_EXIT_ON_ERROR_DESC@AAMsgs"
                   textBinding="STOP_ON_ERROR@AAMsgs" />
   </uix:rowLayout>
      <uix:rowLayout>
           <uix:spacer height ="0" width="20"/>
               <uix:styledText textBinding="IMPLEMENT_EXIT_ON_ERROR_DESC@AAMsgs"
                               styleClass="OraInlineInfoText" />
         </uix:rowLayout>  

   <uix:spacer height="10"/>

<%--
<uix:header textBinding="REVI_SCHED@AAMsgs" >
<uix:styledText textBinding="IMPL_SCHEDDESC@AAMsgs" styleClass="OraFieldText" />
--%>

   <%-- Advanced scheduling options --%>
   <uix:header textBinding="SCHED_OPTIONS@AAMsgs" >
     <jsp:include page="/database/instance/scheduler/scheduleType.jsp" />                
     <uix:ref refID="scheduleType" />
   </uix:header>  

<%--
  <uix:tableLayout cellSpacing="5">
            <uix:cellFormat hAlign="right">
            <uix:messagePrompt 
                  promptBinding="TIME_ZONE@sdkMsgs" labeledNodeId="TIME_ZONE"/>
            </uix:cellFormat>
            <uix:cellFormat>
              <oem:choice
                  id = "TIME_ZONE"
                  name="startTimeZoneSB"
                  optionsBinding="timeZonesSB@scheduleBean@servletRequest"
                  selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"/>
            </uix:cellFormat>
        </uix:tableLayout>
        <%@ include file="/database/instance/scheduler/schedule/start.jspf" %> 
</uix:header>
--%>

 </uix:stackLayout>
    <uix:pageButtons>  
      <uix:pageButtonBar>
        <uix:submitButton textBinding="CANCEL@AAMsgs"
                          shortDescBinding="CANCEL@AAMsgs"
                          name="event"
                          unvalidated="true"
                          value="implcancel"/>
        <uix:submitButton name="event"
                          value="SHOW_SQL"
                          shortDescBinding="SHOWSQL@AAMsgs"
                          textBinding="SHOWSQL@AAMsgs"/>
        <uix:submitButton textBinding="REVI_SUBMIT@AAMsgs"
                           shortDescBinding="REVI_SUBMIT@AAMsgs"
                           disabledBinding = "partitionRecommendation@objectBean@servletRequest"
                           name="event"
                           value="submitImplJob"
                           destinationBinding="destination@objectBean@servletRequest"/>
     </uix:pageButtonBar>
    </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
