<%--
  -- Page:        process.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Process (in progress) page displayed during execution 
  --              of a SQL Access Advisor Quick Tune task
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  10/16/04 - don't hardcode url prefix in images 
  --     kmckeen   09/01/04 - Remove percentComplete attr from uix:processing 
  --                          tag 
  --     mpawelko  08/05/04 - EMUX review edits 
  --     mpawelko  03/05/04 - mpawelko_add_aa_quick_tune 
  --     mpawelko  03/05/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%-- <%@ include file="/enablePPR.jspf" %> --%>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <db:form name="processForm" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,processId,advisoryCentralURL,dbPageNum">
      <uix:formValue name="pageName" value="/database/sqlaccess/process" />

        <uix:pageLayout>
	  <%@ include file="/database/globalPopup.jspf" %>
 
          <uix:header textBinding="QT_PROCESSING@AAMsgs"
                      iconBinding="processIcon@objectBean@servletRequest" >
            <uix:stackLayout>
              <uix:spacer height="5" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="QT_PROGRESS_DESC@AAMsgs"/>
              <uix:spacer height="5" />
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="QT_PROGRESS_DESC2@AAMsgs"/>
              <uix:spacer height="20"/> 

              <uix:processing timeInterval="<%=processingPageInterval%>">
                <uix:styledText styleClass="OraProcessingStatusFixed"
                                textBinding="QT_PROGRESS@AAMsgs"/>
              </uix:processing>
              <uix:spacer height="20"/> 
            <uix:tip>
              <uix:styledText styleClass="OraTipText" 
                              textBinding="QT_TIP@AAMsgs" />
                              
            </uix:tip>
            </uix:stackLayout>
          </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="RETURN@AAMsgs" 
                                name="event" 
                                value="cancel" /> 
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>


