<%--
  -- Page:        quickTune.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Launch page for SQL Access Advisor Quick Tune task
  --
  --  MODIFIED    (MM/DD/YY)
  --     sshastry  03/20/06 - 
  --     mpawelko  05/17/05 - fix oac violations 
  --     mpawelko  10/01/04 - add parsing schema 
  --     mpawelko  08/07/04 - fix copyParams 
  --     mpawelko  03/05/04 - mpawelko_add_aa_quick_tune 
  --     mpawelko  03/05/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <%-- Include body tag so page is indented from edge of window --%>
    <uix:body>

       <%-- HTML Form --%>
       <db:form name="access" 
                method="post" 
                destinationBinding="destination@objectBean@servletRequest"
                copyParams="target,type,advisoryCentralURL,dbPageNum" >
         <uix:formValue name="pageName" 
                        value="/database/sqlaccess/quickTune" />

         <uix:pageLayout titleBinding = "QT@AAMsgs">

           <%-- Oracle Logo and Tabs --%>
           <%@ include file="/database/global.jspf" %>

           <%-- Warning/Error display --%>
           <oem:messageBox messageType="info" 
                           errorTableBinding="info@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" 
                           errorTableBinding="errors@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>

           <uix:pageStatus>
             <uix:rowLayout>
               <uix:styledText textBinding="QT_DESC@AAMsgs"
                               styleClass="OraInstructionText"/>
	     </uix:rowLayout>
           </uix:pageStatus>

           <%-- START: PAGE CONTENTS starts here --%>
           <uix:stackLayout>
             <uix:spacer height="10"/>

             <uix:labeledFieldLayout columns="1" labelWidth="15%" fieldWidth="85%">
               <%-- Task Name --%>
               <uix:messagePrompt styleClass="OraPromptText"
                                  labeledNodeId="taskNameID"
                                  promptBinding="REVI_TASKNAME@AAMsgs" 
                                  required="yes" />
               <uix:textInput name="taskID" 
                              id="taskNameID" 
                              shortDescBinding="REVI_TASKNAME@AAMsgs"
                              textBinding="taskID@objectBean@servletRequest"
                              columns="30" />

               <uix:spacer height="1"/>
               <uix:spacer height="1"/>

               <%-- Task Description (hardcoded before 10gR2) --%>   
               <uix:messagePrompt styleClass="OraPromptText"
                                  labeledNodeId="taskDescID"
                                  promptBinding="REVI_TASKDESC@AAMsgs" />

               <uix:textInput name="taskDescription" 
                              id="taskDescID" 
                              shortDescBinding="REVI_TASKDESC@AAMsgs"
                              disabledBinding="is10gR1@objectBean@servletRequest"
                              textBinding="taskDescription@objectBean@servletRequest"
                              columns="80" />

               <uix:spacer height="1"/>
               <uix:spacer height="1"/>

               <%-- Parsing Schema (not possible before 10gR2) --%>
               <uix:messageLovField id="quickTuneSchema" 
                                    name="quickTuneSchema" 
                                    required="yes"
                                    promptBinding="QT_SCHEMA@AAMsgs"
                                    searchDescBinding="QT_SCHEMA@AAMsgs"
	         	            renderedBinding="is10gR2OrHigher@objectBean@servletRequest"
                                    textBinding="quickTuneSchema@objectBean@servletRequest"
                                    onClick="startLov('quickTuneSchema', 'ListSchema');return false" />

               <uix:spacer height="1"/>
               <uix:spacer height="1"/>

               <%-- SQL Statement --%>   
               <uix:messagePrompt styleClass="OraPromptText"
                                  labeledNodeId="sqlStatementID"
                                  promptBinding="QT_SQL@AAMsgs"
                                  required="yes" />
               <uix:textInput name="quickTuneSQL" 
                              id="sqlStatementID" 
                              shortDescBinding="QT_SQL@AAMsgs"
                              textBinding="quickTuneSQL@objectBean@servletRequest"
                              wrap="soft"
                              rows="10"
                              columns="85" />

             </uix:labeledFieldLayout>
           </uix:stackLayout>

           <uix:hideShow id="quickTuneHideShow"
                         undisclosedTextBinding="SHOW_OPT@AAMsgs"
                         disclosedTextBinding="HIDE_OPT@AAMsgs"
                         disclosedBinding="quickTuneShowOptions@objectBean@servletRequest"
                         formName="access"
                         formSubmitted="true">

             <uix:header textBinding="viewOptionsHeader@objectBean@servletRequest">
               <%@ include file="qtOptions.jspf" %>
             </uix:header>

           </uix:hideShow>
           <%-- END: PAGE CONTENTS ends here --%>   

           <%-- Buttons --%>
           <uix:pageButtons>
             <uix:pageButtonBar>
               <uix:submitButton textBinding="CANCEL@AAMsgs"
                                 shortDescBinding="CANCEL@AAMsgs"
                                 name="event"
                                 unvalidated="true"
                                 value="cancel" />
               <uix:submitButton textBinding="OK@AAMsgs"
                                 shortDescBinding="OK@AAMsgs"
			         name="event"
                                 value="quickTune" />
             </uix:pageButtonBar>
           </uix:pageButtons>

         </uix:pageLayout>
       </db:form>
       <%-- END: HTML Form --%>

    </uix:body>
  </uix:document>
</uix:renderingContext>
 
