<%--
  -- Page:        reviewInputs.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: 4th and final step of SQL Access Advisor task creation wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --     misun     03/06/07 - fix SQL Access Advisor UI Exit Review bugs.
  --     misun     01/05/07 - XbranchMerge misun_bug-5675432 from main
  --     misun     12/14/06 - fix bug 5675432
  --     misun     07/20/06 - add button to set whether show all options                           
  --     mpawelko  06/24/05 - bug 4442980: warn if task script too long 
  --     mpawelko  05/13/05 - fix oac violations 
  --     mpawelko  03/29/05 - final 10.2 gui review changes 
  --     mpawelko  10/15/04 - use UIXDataSource constants 
  --     mpawelko  10/09/04 - convert accessReviewInputTableUI table to uix 
  --     mpawelko  09/08/04 - add link to message box to set filter options if none set
  --     glavash   03/03/03 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%@ include file="/oemTitle.jspf" %>

    <%-- Include body tag so page is indented from edge of window --%>
    <uix:body>

<%-- HTML Form --%>
<db:form name="access" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,advisoryCentralURL,dbPageNum" >
<uix:formValue name="pageName" value="/database/sqlaccess/reviewInputs"/>

<uix:pageLayout titleBinding="REVI_TITLE@AAMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

    <%-- Display wizard train and Logged in As --%>
    <uix:location>
        <uix:train selectedIndex="3">
            <db:link textBinding="STEP_WORKLOAD@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_METHODS@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="REVI_SCHED@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_REVIEW@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
        </uix:train>
    </uix:location>
 
     <uix:pageStatus>
       <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
     </uix:pageStatus>
     <%-- Follow page/wizard context information with a separator --%>
     <uix:separator/>

           <%-- Warning/Error display --%>
            <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
	          destTableBinding="urls@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
	          destTableBinding="urls@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           
 <uix:spacer height="1"/>
 <uix:stackLayout>
 <uix:styledText textBinding="REVI_TEXT1@AAMsgs"
 styleClass="OraFieldText" />
 
   <uix:tableLayout cellSpacing="5">
   <uix:spacer height="1"/>
   <uix:rowLayout>
     <uix:cellFormat hAlign="right">
       <uix:styledText textBinding="REVI_TASKNAME@AAMsgs" 
                       styleClass="OraFieldText"/>
     </uix:cellFormat>
     <uix:spacer width="3" />
     <uix:cellFormat hAlign="left">
           <uix:styledText textBinding= "taskID@objectBean@servletRequest" styleClass="OraInstructionTextStrong" />
     </uix:cellFormat>
   </uix:rowLayout>
   <uix:rowLayout>
     <uix:cellFormat hAlign="right">
       <uix:styledText textBinding="REVI_TASKDESC@AAMsgs" styleClass="OraFieldText"/>
     </uix:cellFormat>
     <uix:spacer width="3" />
     <uix:cellFormat hAlign="left">
      <uix:styledText textBinding= "taskDescription@objectBean@servletRequest" styleClass="OraInstructionTextStrong" />
     </uix:cellFormat>
   </uix:rowLayout>
   <uix:rowLayout>
     <uix:cellFormat hAlign="right">
        <uix:styledText textBinding= "REVI_JOBTIME@AAMsgs" styleClass="OraFieldText" />
     </uix:cellFormat>
     <uix:spacer width="3" />
     <uix:cellFormat hAlign="left">
         <uix:styledText textBinding= "reviewTaskStartDate@objectBean@servletRequest" styleClass="OraInstructionTextStrong" />
     </uix:cellFormat>
   </uix:rowLayout>
    </uix:tableLayout>

<uix:spacer height="5" />

<uix:header textBinding="STEP_OPTIONS@AAMsgs" >
    <uix:spacer height="2" />
    <uix:submitButton name="event"
                  value="reverseShowAllOptions"
                  shortDescBinding="showAllOptionsText@objectBean@servletRequest"
                  textBinding="showAllOptionsText@objectBean@servletRequest"/>
    <uix:spacer height="2" />
    
   <uix:dataScope currentDataBinding="accessReviewInputTableUI@objectBean@servletRequest"> 
      <uix:table name="accessReviewInputTableUI" 
                 formSubmitted="true"
                 width="100%"
                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                 summaryBinding="REVI_TEXT1@AAMsgs"
                 minValue="1"
                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
		 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" >

         <uix:tableFormat tableBanding="rowBanding"/>

         <%-- Modification column (blue checkmark if modified) --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="MODIFIED@AAMsgs"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
           <uix:image shortDescBinding="MODIFIED@AAMsgs" 
                    sourceBinding="<%= AccessParameterConstants.S_MODIFICATION_COL %>" /> 
         </uix:column>

         <%-- Option Name column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="OPTION@AAMsgs"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="textFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_OPTION_COL %>" /> 
         </uix:column>

        <%-- Option Value column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="VALUE@AAMsgs"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="textFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_VALUE_COL %>" /> 
         </uix:column>

        <%-- Option Description column --%>
         <uix:column>
           <uix:columnHeader>
             <uix:sortableHeader textBinding="DESCRIPTION@AAMsgs"/>
           </uix:columnHeader> 
           <uix:columnFormat columnDataFormat="textFormat"/>
           <uix:styledText textBinding="<%= AccessParameterConstants.S_DESC_COL %>" /> 
         </uix:column>
       </uix:table>
    </uix:dataScope>
</uix:header>

 </uix:stackLayout>
    <uix:pageButtons>  
      <uix:pageButtonBar>
       <uix:rowLayout>

  <uix:cellFormat>
    <uix:submitButton textBinding="CANCEL@AAMsgs"
                      shortDescBinding="CANCEL@AAMsgs"
         name="event"
         value="cancel"
         destinationBinding="destination@objectBean@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer height="0" width="5" />

  <uix:cellFormat>
    <uix:submitButton name="event"
                  value="SHOW_SQL"
                  shortDescBinding="SHOWSQL@AAMsgs"
                  textBinding="SHOWSQL@AAMsgs"/>
  </uix:cellFormat>
  <uix:spacer height="0" width="5" />
  <uix:cellFormat>
   <uix:navigationBar 
             maxValue="4" minValue="1" name="step" value="4" 
             destinationBinding="destination@objectBean@servletRequest"
             formSubmitted="true"
             formName="access" />
  </uix:cellFormat>
  <uix:spacer height="0" width="5" />
  <uix:cellFormat>
  <uix:submitButton textBinding="REVI_SUBMIT@AAMsgs"
                    shortDescBinding="REVI_SUBMIT@AAMsgs"
             name="event"
             value="submitDBJob"
             destinationBinding="destination@objectBean@servletRequest"/>
  </uix:cellFormat>

</uix:rowLayout>
     </uix:pageButtonBar>
    </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
