<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:importScript names="submitForm()"/> 

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>

  <%-- AdvisorTaskMsg needed for taskInfo.jspf include --%>
  <uix:bundle name="AdvisorTaskMsg"
              class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
 
    <uix:body>

      <db:form name="review" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,advisoryCentralURL,dbPageNum,pageName" >
      <uix:formValue name="pageName" value="/database/sqlaccess/reviewRec" />

      <uix:pageLayout titleBinding="recommendationHeader@objectBean@servletRequest" >

        <%-- Oracle Logo and Tabs --%>
        <%@ include file="/database/global.jspf" %>

        <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" 
	                  mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" 
	                  mainTextKey="mainText"/>

  
        <uix:spacer height="10"/>

        <%@ include file="taskInfo.jspf" %>

        <uix:spacer height="10"/>
 
        <uix:stackLayout renderedBinding="haveNoTaskError@objectBean@servletRequest">
    
            <uix:subTabBar selectedIndexBinding="recViewSel@objectBean@servletRequest">
                   <db:link textBinding="REVREC_VIEWSUMM@AAMsgs"
                             shortDescBinding="REVREC_VIEWSUMM@AAMsgs"
                             onClick="submitForm('review', true, {event:'recViewChange1'})"
                             copyParams="target,type,advisoryCentralURL,dbPageNum" />
                    <db:link textBinding="REVREC_REC@AAMsgs"
                             shortDescBinding="REVREC_REC@AAMsgs"
                             onClick="submitForm('review', true, {event:'recViewChange2'})"
                             copyParams="target,type,advisoryCentralURL,dbPageNum" />
                   <db:link textBinding="REVREC_VIEWSQL@AAMsgs"
                             shortDescBinding="REVREC_VIEWSQL@AAMsgs"
                             onClick="submitForm('review', true, {event:'recViewChange3'})"
                             copyParams="target,type,advisoryCentralURL,dbPageNum" />
                   <db:link textBinding="REVREC_VIEWTASK@AAMsgs"
                             shortDescBinding="REVREC_VIEWTASK@AAMsgs"
                             onClick="submitForm('review', true, {event:'recViewChange4'})"
                             copyParams="target,type,advisoryCentralURL,dbPageNum" />
            </uix:subTabBar>

            <uix:stackLayout renderedBinding="isSummView@objectBean@servletRequest" >
              <jsp:include page="revsumminc.jsp" />
              <uix:ref refID="revsumminc" /> 
            </uix:stackLayout>
            <uix:stackLayout renderedBinding="isRecView@objectBean@servletRequest" >
              <%@ include file="revrecinc.jspf" %>
            </uix:stackLayout>
            <uix:stackLayout renderedBinding="isSqlView@objectBean@servletRequest" >
              <%@ include file="revsqlinc.jspf" %>
            </uix:stackLayout>
            <uix:stackLayout renderedBinding="isTaskView@objectBean@servletRequest" >
              <%@ include file="revtaskinc.jspf" %>
            </uix:stackLayout>

        </uix:stackLayout>

        <uix:stackLayout renderedBinding="haveTaskError@objectBean@servletRequest">
          <%@ include file="revtaskinc.jspf" %>
        </uix:stackLayout>

        <uix:spacer height="10"/>
 
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
