<%--
  -- Page:        schedule.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: 3rd step of SQL Access Advisor task creation wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --     misun     03/06/07 - fix SQL Access Advisor UI Exit Review bugs.
  --     misun     11/02/06 - extend Total Time Limit text box wide
  --     misun     07/20/06 - add Total Time Limit (minutes) 
  --     mpawelko  03/29/05 - final 10.2 gui review changes 
  --     mpawelko  09/29/04 - add Task Expiration (days) 
  --     mpawelko  09/08/04 - remove mv warning if 10gR2 
  --     mpawelko  08/18/04 - remove second include of utils 
  --     mpawelko  08/10/04 - add descriptions in shortDesc 
  --     mpawelko  08/06/04 - add journaling tip, fix browser title 
  --     glavash   03/03/03 - created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
<%-- bundle, ScheduleBundle, and DBScheduleBundle required by include --%>
<uix:bundle name="bundle"                   
          class="oracle.sysman.db.rsc.inst.JobsMsg"/>
<uix:bundle name="ScheduleBundle"                   
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
    

    <uix:metaContainer>
      <db:script src="/database/utils.js"/>
      <script>
      function myCallBack(lovwin, event)
      {          
      }
      </script>
    </uix:metaContainer>


    <%-- Include body tag so page is indented from edge of window --%>
    <uix:body>

<%-- HTML Form --%>
<db:form name="scheduleForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,advisoryCentralURL,dbPageNum" >
 <uix:formValue name="pageName" value="/database/sqlaccess/schedule"/> 
 
<uix:pageLayout titleBinding="SCHED_TITLE@AAMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

    <%-- Display wizard train and Logged in As --%>
    <uix:location>
        <uix:train selectedIndex="2">
            <db:link textBinding="STEP_WORKLOAD@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_METHODS@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="REVI_SCHED@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_REVIEW@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
        </uix:train>
    </uix:location>

    <uix:pageStatus>
      <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
    </uix:pageStatus>
     <%-- Follow page/wizard context information with a separator --%>
     <uix:separator/>

           <%-- Warning/Error display --%>
            <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           
 <uix:spacer height="1"/>
 <uix:stackLayout>
 <%-- If 10g, warn about evaluating mv's in a maintenance window --%>
 <uix:switcher childNameBinding="is10gR2OrHigher@objectBean@servletRequest">
   <uix:case name="false">
     <uix:tip>
       <uix:styledText textBinding="SCHED_TEXT@AAMsgs"  styleClass="OraTipText"  />
     </uix:tip>
   </uix:case>
 </uix:switcher>

<uix:header textBinding="SCHED_ADVISOR_TASKNAME@AAMsgs">
  <uix:spacer height="5"/>
  <uix:rowLayout>
    <uix:messageTextInput name="taskID" 
                          id="REVI_TASKNAME" 
	                  promptBinding="REVI_TASKNAME@AAMsgs"
                          required="yes"
                          shortDescBinding="REVI_TASKNAME@AAMsgs"
                          textBinding="taskID@objectBean@servletRequest"
                          disabledBinding="taskExists@objectBean@servletRequest"
                          columns="30" />
  </uix:rowLayout>
  <uix:spacer height="10"/>
  <uix:rowLayout>
    <uix:messageTextInput name="taskDescription" 
                          id="REVI_TASKDESC" 
                          promptBinding="REVI_TASKDESC@AAMsgs"
                          shortDescBinding="REVI_TASKDESC@AAMsgs"
                          textBinding="taskDescription@objectBean@servletRequest"
                          disabledBinding="taskExists@objectBean@servletRequest"
                          columns="70" />
  </uix:rowLayout>
  <uix:spacer height="10"/>
  <uix:rowLayout>
    <uix:messageChoice name="journalLevel" 
                       promptBinding="JOURNALING@AAMsgs"
                       tipBinding="JOURNALING_TIP@AAMsgs"
                       shortDescBinding="JOURNALING_DESC@AAMsgs"
                       selectedValueBinding="journalLevel@objectBean@servletRequest" >
      <uix:option textBinding="J_NONE@AAMsgs" value="0" />
      <uix:option textBinding="J_BASIC@AAMsgs" value="4" />    
      <uix:option textBinding="J_MODERATE@AAMsgs" value="6" />    
      <uix:option textBinding="J_FULL@AAMsgs" value="9" />
    </uix:messageChoice>
  </uix:rowLayout>

  <uix:spacer height="10"/>
  <uix:rowLayout>
    <uix:messageTextInput name="expiration" 
                          id="DAYS_TO_EXPIRE" 
                          promptBinding="DAYS_TO_EXPIRE@AAMsgs"
                          tipBinding="DAYS_TO_EXPIRE_TIP@AAMsgs"
                          shortDescBinding="DAYS_TO_EXPIRE_DESC@AAMsgs"
                          textBinding="expiration@objectBean@servletRequest"
                          required="yes"
                          columns="4" >
    <uix:onSubmitValidater>
      <uix:regExp pattern="[1-9]+[0-9]*$"/>
    </uix:onSubmitValidater>
    </uix:messageTextInput>
  </uix:rowLayout>

  <uix:spacer height="10" renderedBinding="versionEqualOrHigher11g@objectBean@servletRequest"/>
  <uix:rowLayout renderedBinding="versionEqualOrHigher11g@objectBean@servletRequest">
    <uix:messageTextInput name="totalTimeLimit" 
                          id="TOTAL_TIME_LIMIT" 
                          promptBinding="TOTAL_TIME_LIMIT@AAMsgs"
                          shortDescBinding="TOTAL_TIME_LIMIT_DESC@AAMsgs"
                          textBinding="totalTimeLimit@objectBean@servletRequest"
                          required="yes"
                          columns="5" >
    <uix:onSubmitValidater>
      <uix:regExp pattern="[1-9]+[0-9]*$"/>
    </uix:onSubmitValidater>
    </uix:messageTextInput>
  </uix:rowLayout>

</uix:header>
  <uix:spacer height="1" />

  <%-- Advanced scheduling options --%>
  <uix:header textBinding="SCHED_OPTIONS@AAMsgs" >
    <jsp:include page="/database/instance/scheduler/scheduleType.jsp" />                
    <uix:ref refID="scheduleType" />
  </uix:header>  
 
 </uix:stackLayout>
    <uix:pageButtons>  
      <uix:pageButtonBar>
 <uix:rowLayout>

  <uix:cellFormat>
  <uix:spacer height="0" width="5" />

  <uix:submitButton textBinding="CANCEL@AAMsgs"
                    shortDescBinding="CANCEL@AAMsgs"
         name="event"       
         value="cancel"
         unvalidated="true"
         destinationBinding="destination@objectBean@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer height="0" width="5" />
  <uix:cellFormat>
   <uix:navigationBar 
             maxValue="4" minValue="1" name="step" value="3" 
             destinationBinding="destination@objectBean@servletRequest"
             formSubmitted="true"
             formName="scheduleForm" />
  </uix:cellFormat>

</uix:rowLayout>
     </uix:pageButtonBar>
    </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
