<%--
  -- Page:        schemaTables.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Drilldown page to build list of schemas and/or tables
  --              Replacement for Schema/Table LOV, which doesn't provide a way to
  --              search for schemas.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko   06/27/05 - change hint to say wildcards are allowed 
  --     mpawelko   06/21/05 - mpawelko_bug-4186598
  --     mpawelko   06/08/05 - created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
    
  <%-- Include body tag so page is indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="schemaTablesForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,advisoryCentralURL,dbPageNum" >
      <uix:formValue name="pageName" value="/database/sqlaccess/schemaTables"/> 
 
      <uix:pageLayout titleBinding="WKLD_SCHEMA_TABLE@AAMsgs">

        <%-- Oracle Logo and Tabs --%>
        <%@ include file="/database/globalPopup.jspf" %>

        <%-- Display wizard train and Logged in As --%>
        <uix:location>
          <uix:tableLayout width="100%">
            <uix:rowLayout width="100%">
              <uix:cellFormat wrappingDisabled="true">
                <uix:train selectedIndex="0">
                  <db:link textBinding="STEP_WORKLOAD@AAMsgs"
                           disabled="true" />
                  <db:link textBinding="STEP_METHODS@AAMsgs"
                           disabled="true" />
                  <db:link textBinding="REVI_SCHED@AAMsgs"
                           disabled="true" />
                  <db:link textBinding="STEP_REVIEW@AAMsgs"
                           disabled="true" />
                </uix:train>
              </uix:cellFormat>
              <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
                <uix:messageStyledText styleClass="OraTipText" 
                                       textBinding="loggedInAsLabel@servletRequest"
                                       renderedBinding="loggedInUserNameAvailable@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:location>

        <uix:pageStatus>
          <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
        </uix:pageStatus>
        <%-- Follow page/wizard context information with a separator --%>
        <uix:separator/>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
           
        <uix:spacer height="1"/>
        <uix:stackLayout>
          <uix:rowLayout>
            <uix:styledText textBinding="SCHEMA_TABLE_TEXT@AAMsgs"  
                            renderedBinding="isHypoLOV@objectBean@servletRequest"
                            styleClass="OraInstructionText"/>

            <uix:styledText textBinding="SCHEMA_TABLE_TEXT2@AAMsgs"  
                            renderedBinding="isTableIncLOV@objectBean@servletRequest"
                            styleClass="OraInstructionText"/>

            <uix:styledText textBinding="SCHEMA_TABLE_TEXT3@AAMsgs"  
                            renderedBinding="isTableExcLOV@objectBean@servletRequest"
                            styleClass="OraInstructionText"/>
          </uix:rowLayout>
          <uix:spacer height="10"/>

          <uix:rowLayout>          
            <uix:switcher childNameBinding="isHypoLOV@objectBean@servletRequest">
              <uix:case name="true">                  
                <uix:messageTextInput name="schemaTables"
                                      rows="5" columns="70"	
                                      promptBinding="SCHEMAS_TABLES@AAMsgs"
                                      shortDescBinding="SCHEMAS_TABLES@AAMsgs"
                                      tipBinding="COMMA@AAMsgs"
                                      textBinding="schemaTables@objectBean@servletRequest" />
              </uix:case>
              <uix:case name="false">                  
                <uix:messageTextInput name="schemaTables"
                                      rows="5" columns="70"	
                                      promptBinding="SCHEMAS_TABLES@AAMsgs"
                                      shortDescBinding="SCHEMAS_TABLES@AAMsgs"
                                      tipBinding="COMMA_WILDCARD@AAMsgs"
                                      textBinding="schemaTables@objectBean@servletRequest" />
              </uix:case>
            </uix:switcher>
          </uix:rowLayout>
          <uix:spacer height="10"/>

          <uix:header textBinding="SCHEMAS@AAMsgs">

            <%-- Schema --%>
            <uix:rowLayout>
              <uix:switcher childNameBinding="isHypoLOV@objectBean@servletRequest">
                <uix:case name="true">   
                  <uix:messageLovField name="addSchemaNames"
                                       id="SCHEMAS" shortDescBinding="SCHEMAS@AAMsgs"
  rows="2" columns="70"
                                       promptBinding="SCHEMAS@AAMsgs"
                                       searchDescBinding="SCHEMAS@AAMsgs"
                                       textBinding="addSchemaNames@objectBean@servletRequest" 
                                       tipBinding="COMMA@AAMsgs"
                                       onClick="selectMultiple();appendData();startLov('addSchemaNames', 'ListSchema')" />
                </uix:case>
                <uix:case name="false">  
                  <uix:messageLovField name="addSchemaNames"
                                       id="SCHEMAS" shortDescBinding="SCHEMAS@AAMsgs"
  rows="2" columns="70"
                                       promptBinding="SCHEMAS@AAMsgs"
                                       searchDescBinding="SCHEMAS@AAMsgs"
                                       textBinding="addSchemaNames@objectBean@servletRequest" 
                                       tipBinding="COMMA_WILDCARD@AAMsgs"
                                       onClick="selectMultiple();appendData();startLov('addSchemaNames', 'ListSchema')" />
                </uix:case>
              </uix:switcher>
              <uix:spacer width="10"/>
              <uix:submitButton name="event"
                                value = "addSchemas"
                                textBinding="ADD_SCHEMAS@AAMsgs"
                                shortDescBinding="ADD_SCHEMAS@AAMsgs" />
            </uix:rowLayout>                            
            <uix:spacer height="10"/>
            <uix:tip>
              <uix:styledText textBinding="ADD_SCHEMAS_HINT@AAMsgs"  
                              renderedBinding="isHypoLOV@objectBean@servletRequest"
                              styleClass="OraTipText" />

              <uix:styledText textBinding="ADD_SCHEMAS_HINT2@AAMsgs"  
                              renderedBinding="isTableIncLOV@objectBean@servletRequest"
                              styleClass="OraTipText" />

              <uix:styledText textBinding="ADD_SCHEMAS_HINT3@AAMsgs"  
                              renderedBinding="isTableExcLOV@objectBean@servletRequest"
                              styleClass="OraTipText" />
            </uix:tip>
          </uix:header>

          <uix:header textBinding="WKLDFLT_TABLIST@AAMsgs">

            <uix:tableLayout cellPadding="3">
	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="center">
                  <uix:messagePrompt promptBinding="SCHEMA@AAMsgs" labeledNodeId="filter0" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="center">
                  <uix:messageLovField name="addSchemaFilter"
                                       id="filter0"  columns="35" shortDescBinding="SCHEMA@AAMsgs"
                                    
                                       searchDescBinding="SCHEMA@AAMsgs"
                                       textBinding="addSchemaFilter@objectBean@servletRequest" 
                                       onClick="startLov('addSchemaFilter', 'ListSchema')" />
                </uix:cellFormat>
              </uix:rowLayout>
	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="center">
                  <uix:messagePrompt promptBinding="TABLE@AAMsgs" labeledNodeId="filter1"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="center">
                  <uix:messageTextInput name="addTableFilter"
                                        id="filter1" shortDescBinding="TABLE@AAMsgs"
 columns="35"
                                        textBinding="addTableFilter@objectBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="center">
                  <uix:styledText text=""/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="center">
                  <uix:submitButton name="event"
                                    value = "populateTables"
                                    textBinding="SEARCH_TABLES@AAMsgs"
                                    shortDescBinding="SEARCH_TABLES@AAMsgs" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

	    <uix:rowLayout>
              <uix:styledText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@AAMsgs" />
            </uix:rowLayout>

            <uix:separator>
              <uix:spacer height="3"/>
            </uix:separator>

            <%-- Display tasks and templates  --%>
            <uix:dataScope currentDataBinding="accessSchemaTablesTableUI@objectBean@servletRequest"> 
              <uix:table id="accessSchemaTablesTableUI" 
                         formSubmitted="true"
                         width="100%"
                         summaryBinding="SCHEMA_TABLE_TEXT@AAMsgs"
                         tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                         minValue="1"
                         valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                         maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                         showAll="yes"
                         partialRenderMode="self"	
                         alternateTextBinding="<%= AccessParameterConstants.S_EMPTY_TABLE %>"
                         blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <%-- Schema column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="SCHEMA@AAMsgs"
                                        sortableBinding="<%= AccessParameterConstants.S_SORT_SCHEMA %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= AccessParameterConstants.S_SCHEMA_COL %>" />
                </uix:column>

                <%--  Table column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TABLE@AAMsgs"
                                        sortableBinding="<%= AccessParameterConstants.S_SORT_SCHEMA_TABLE %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= AccessParameterConstants.S_SCHEMA_TABLE_COL %>" /> 
                </uix:column>

                <uix:tableSelection>
                  <uix:multipleSelection shortDescBinding="SELECT_TASK_DESC@AAMsgs"
                                         selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>">

                    <uix:submitButton textBinding="ADD_TABLES@AAMsgs" 
                                      shortDescBinding="ADD_TABLES_HINT@AAMsgs" 
                                      name="event" 
                                      value="addTables" />
                  </uix:multipleSelection>
                </uix:tableSelection>
              </uix:table>
            </uix:dataScope>

            <uix:spacer height="10"/>
            <uix:tip>
              <uix:styledText textBinding="ADD_TABLES_HINT@AAMsgs"  
                              renderedBinding="isHypoLOV@objectBean@servletRequest"
                              styleClass="OraTipText" />

              <uix:styledText textBinding="ADD_TABLES_HINT2@AAMsgs"  
                              renderedBinding="isTableIncLOV@objectBean@servletRequest"
                              styleClass="OraTipText" />

              <uix:styledText textBinding="ADD_TABLES_HINT3@AAMsgs"  
                              renderedBinding="isTableExcLOV@objectBean@servletRequest"
                              styleClass="OraTipText" />
            </uix:tip>
          </uix:header>
        </uix:stackLayout>
        <uix:pageButtons>  
          <uix:pageButtonBar>
            <uix:submitButton name="event"
                              value="addSchemaTablesCancel"
                              textBinding="CANCEL@AAMsgs"
                              shortDescBinding="CANCEL@AAMsgs" />
            <uix:submitButton name="event"
                              value = "addSchemaTablesOK"
                              textBinding="OK@AAMsgs"
                              shortDescBinding="OK@AAMsgs" />
         </uix:pageButtonBar>
       </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   <%-- END: HTML Form --%>
 </uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
