<%--
  -- Page:        showSql.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Show either the full text of a single SQL statement, or the advisor implementation task script.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  08/06/04 - use separate file for Show Sql in wizard, so location separator doesn't show 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
  
    <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body>

       <%-- HTML Form --%>
        <db:form name="access" 
                 method="post" 
                 destinationBinding="destination@objectBean@servletRequest"
                 copyParams="target,type,advisoryCentralURL,dbPageNum" >
          <uix:formValue name="pageName" value="/database/sqlaccess/showSql"/>

          <uix:pageLayout titleBinding="SHOWSQL@AAMsgs">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>

          <%-- START: CONTENTS starts here --%>
          <uix:stackLayout>
            <db:sqlDisplay  sqlListBinding="showMeTheSql@objectBean@servletRequest"/>
          </uix:stackLayout>
          <%-- END: TAB CONTENTS ends here --%>   

          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event"
                                value="OK"
                                shortDescBinding="RETURN@AAMsgs"
                                textBinding ="RETURN@AAMsgs" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
 
