<%--
  -- Page:        showSqlWiz.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Shows the advisor task creation script, while in the wizard.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  06/10/05 - disable train 
  --     mpawelko  03/29/05 - final 10.2 gui review changes 
  --     mpawelko  08/08/04 - mpawelko_bug-3807984
  --     mpawelko  08/06/04 - creation
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
  
    <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body>
<uix:stackLayout>

       <%-- HTML Form --%>
        <db:form name="access" 
                 method="post" 
                 destinationBinding="destination@objectBean@servletRequest"
                 copyParams="target,type,advisoryCentralURL,dbPageNum" >
          <uix:formValue name="pageName" value="/database/sqlaccess/showSqlWiz"/>

          <uix:pageLayout titleBinding="REV_SHOWSQL@AAMsgs">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/globalPopup.jspf" %>

          <%-- Display wizard train and Logged in As --%>
          <uix:location>
            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%">
                <uix:cellFormat wrappingDisabled="true">
                  <uix:train selectedIndex="3">
                    <db:link textBinding="STEP_WORKLOAD@AAMsgs"
                             disabled="true" />
                    <db:link textBinding="STEP_METHODS@AAMsgs"
                             disabled="true" />
                    <db:link textBinding="REVI_SCHED@AAMsgs"
                             disabled="true" />
                    <db:link textBinding="STEP_REVIEW@AAMsgs"
                             disabled="true" />
                  </uix:train>
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
                  <uix:messageStyledText styleClass="OraTipText" 
                                         textBinding="loggedInAsLabel@servletRequest"
                                         renderedBinding="loggedInUserNameAvailable@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:location>

          <%-- START: CONTENTS starts here --%>
          <uix:stackLayout>
            <db:sqlDisplay  sqlListBinding="showMeTheSql@objectBean@servletRequest"/>
          </uix:stackLayout>
          <%-- END: TAB CONTENTS ends here --%>   

          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event"
                                value="OK"
                                shortDescBinding="RETURN@AAMsgs"
                                textBinding ="RETURN@AAMsgs" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
</uix:stackLayout>

    </uix:body>
  </uix:document>
</uix:renderingContext>
  
