<%--
  -- Page:        tuneOptions.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: First page displayed when user clicks SQL Access Advisor
  --              link.  User selects between tuning a workload and tuning
  --              one statement (quick tune), and optionally selects a task
  --              or template to inherit initial parameter values from.
  --               
  --
  --  MODIFIED    (MM/DD/YY)
  --     misun     06/14/07 - fix the bug 6128665: nls: hardcode string 'view'
  --                          in sql access advisor: initial options page.
  --     misun     02/26/07 - fix SQL Access Advisor Executive Review bugs.
  --     misun     04/24/06 - Add new features: 17610 SQL Advisor - SAA 
  --                          Enhancement 11gR1. 
  --     mpawelko  10/15/04 - convert templates table to uix:table 
  --     mpawelko  08/05/04 - add tasks/templates view choice 
  --     mpawelko  03/05/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
  <uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <%-- Body tag wil indent page from edge of window --%>
    <uix:body>

      <%-- HTML Form --%>
      <db:form name="access" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,advisoryCentralURL,dbPageNum" >
        <uix:formValue name="pageName" value="/database/sqlaccess/tuneOptions"/>
        <uix:pageLayout titleBinding="DEF_OPT_TITLE@AAMsgs">
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>

          <uix:pageStatus>
            <uix:rowLayout>
              <uix:styledText textBinding="TASK_CREATION_TEXT1@AAMsgs"  
                              styleClass="OraInstructionText"/>
	    </uix:rowLayout>	     
          </uix:pageStatus>

          <uix:stackLayout>
            <uix:rowLayout>
                <uix:cellFormat width="53%" vAlign="top">

                <%--uix:stackLayout>
                  <uix:spacer height="5"/>

                  <uix:rowLayout>
                    <uix:spacer width="10" height="2"/>
		    <uix:radioButton name="tuneOption" 
                                     value="<%=AccessParameterConstants.TUNE_WORKLOAD%>" 
                                     selectedValueBinding="tuneOption@objectBean@servletRequest" 
                                     onClick="submitForm('access', true, {event:'hideTemplates'})"
                                     textBinding="DEF_OPTS_BUTTON@AAMsgs" />         
		  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer width="38" height="0" />
                    <uix:styledText textBinding="DEF_OPTS_BUTTON_DESC@AAMsgs"  
                                    styleClass="OraInlineInfoText"  />
                  </uix:rowLayout>
  
                  <uix:spacer height="2"/>

                  <uix:rowLayout>
                    <uix:spacer width="10" height="2"/>
                    <uix:radioButton name="tuneOption" 
                                     value="<%=AccessParameterConstants.QUICK_TUNE%>" 
                                     selectedValueBinding="tuneOption@objectBean@servletRequest"
                                     onClick="submitForm('access', true, {event:'showTemplates'})"
                                     textBinding="SEL_OPTS_BUTTON@AAMsgs" />

                  </uix:rowLayout>
                  <uix:rowLayout>          
                    <uix:spacer height ="0" width="38"/>
                    <uix:styledText textBinding="SEL_OPTS_BUTTON_DESC@AAMsgs"  
                                    styleClass="OraInlineInfoText" />
                  </uix:rowLayout> 
                </uix:stackLayout  --%> 

                    <uix:spacer height="5"/>
                    <uix:rowLayout>
                        <uix:spacer width="10" height="2"/>
                        <uix:radioButton name="tuneOption"
                                    value="<%=AccessParameterConstants.VERIFY_ONLY%>" 
                                    selectedValueBinding="tuneOption@objectBean@servletRequest" 
                                    onClick="submitForm('access', true, {event:'verifyUseOfAccessStructures'})"
                                    textBinding="VERIFY_ONLY_BUTTON@AAMsgs" />         
                    </uix:rowLayout>
  
                    <uix:spacer height="2"/>

                    <uix:rowLayout>
                        <uix:spacer width="10" height="2"/>
                        <uix:radioButton name="tuneOption" 
                                    value="<%=AccessParameterConstants.TUNE_WORKLOAD%>" 
                                    selectedValueBinding="tuneOption@objectBean@servletRequest" 
                                    onClick="submitForm('access', true, {event:'recommendNewAccessStructures'})"
                                    textBinding="DEF_OPTS_BUTTON@AAMsgs" />         
                    </uix:rowLayout>

                    <uix:rowLayout>
                        <uix:spacer width="36" height="2"/>
                        <uix:checkBox name="tuneOptionSelected" 
                                styleClass="OraFieldText"
                                checkedBinding="tuneOptionSelected@objectBean@servletRequest"
                                onClick="submitForm('access', true, {event:'showHideTemplates'})"
                                shortDescBinding="SEL_OPTS_BUTTON@AAMsgs"
                                textBinding="SEL_OPTS_BUTTON@AAMsgs" />
                    </uix:rowLayout>

                </uix:cellFormat>     
                <uix:cellFormat width="2%" />
              
              <uix:cellFormat width="45%" vAlign="top" hAlign="center" >
                <uix:spacer width="10"/>
                <uix:contentContainer textBinding="OVERVIEW_TITLE@AAMsgs" width="100%">
                  <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer width="10" height="7"/>
                    </uix:separator>
                    <uix:switcher childNameBinding="dbVersion@objectBean@servletRequest">
                        <uix:case name="10g">
                            <uix:styledText textBinding="OVERVIEW_TEXT@AAMsgs"
                                    styleClass="OraInstructionText"/>
                        </uix:case>
                        <uix:case name="11gR1">
                            <uix:styledText textBinding="OVERVIEW_TEXT_11G@AAMsgs"
                                    styleClass="OraInstructionText"/>
                        </uix:case>
                    </uix:switcher>
                  </uix:stackLayout>
                </uix:contentContainer>
              </uix:cellFormat>
            </uix:rowLayout>  
          </uix:stackLayout> 

          <uix:spacer height="10"/>         

          <uix:rowLayout>
            <uix:tip>
              <uix:styledText textBinding="TEMPLATE_TIP@AAMsgs"  
                              styleClass="OraTipText" />
            </uix:tip>
          </uix:rowLayout>  

          <uix:stackLayout renderedBinding="showTemplates@objectBean@servletRequest">
            <uix:spacer height="10"/>  
            <%@ include file="templates.jspf" %>
          </uix:stackLayout>       

          <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@AAMsgs"
                                shortDescBinding="CANCEL@AAMsgs"
                                name="event"
                                unvalidated="true"
                                value="cancel" />
              <uix:submitButton textBinding="CONTINUE@AAMsgs"
                                shortDescBinding="CONTINUE@AAMsgs"
                                name="event"
                                value="continue" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
