<%--
  -- Page:        viewOptions.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Displays the workload and parameter settings for an 
  --              existing task or template.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  05/13/05 - fix oac violations 
  --     mpawelko  03/29/05 - final 10.2 gui review changes 
  --     mpawelko  10/15/04 - use UIXDataSource constants 
  --     mpawelko  10/09/04 - convert accessReviewInputTableUI table to uix 
  --     mpawelko  08/26/04 - use table to display options 
  --     mpawelko  08/06/04 - fix browser title 
  --     mpawelko  02/26/04 - mpawelko_support_aa_templates 
  --     mpawelko  02/23/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs"
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <%-- Include body tag so page is indented from edge of window --%>
    <uix:body>
      <uix:contents>

        <%-- HTML Form --%>
        <db:form name="access" 
                 method="post" 
                 destinationBinding="destination@objectBean@servletRequest"
		 copyParams="target,type,advisoryCentralUrl,dbPageNum" >
          <uix:formValue name="pageName" value="/database/sqlaccess/viewOptions"/>
          <uix:pageLayout titleBinding = "viewOptionsHeader@objectBean@servletRequest">
  
            <%-- Oracle Logo and Tabs --%>
            <%@ include file="/database/global.jspf" %>

            <%-- START: PAGE CONTENTS starts here --%>
            <uix:pageStatus>
              <uix:styledText textBinding="viewOptionsDesc@objectBean@servletRequest"
                              styleClass="OraFieldText" /> 
            </uix:pageStatus>
            <uix:spacer height="5" />
            <uix:dataScope currentDataBinding="accessReviewInputTableUI@objectBean@servletRequest"> 
              <uix:table name="accessReviewInputTableUI" 
                         formSubmitted="true"
                         width="100%"
                         tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                         summaryBinding="viewOptionsDesc@objectBean@servletRequest"
                         minValue="1"
                         valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                         maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
			 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <%-- Option Name column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="OPTION@AAMsgs"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= AccessParameterConstants.S_OPTION_COL %>" /> 
                </uix:column>

                <%-- Option Value column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="VALUE@AAMsgs"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= AccessParameterConstants.S_VALUE_COL %>" /> 
                </uix:column>
 
                <%-- Option Description column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="DESCRIPTION@AAMsgs"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= AccessParameterConstants.S_DESC_COL %>" /> 
                </uix:column>
              </uix:table>
            </uix:dataScope>
            <%-- END: PAGE CONTENTS ends here --%>   

            <%-- Buttons --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- Without spacer, buttons display right against pageStatus text - Cabo bug? --%>
                <uix:spacer width="1" />
                <uix:submitButton name="event"
                                  value="OK"
                                  shortDescBinding="RETURN@AAMsgs"
                                  textBinding ="RETURN@AAMsgs" />
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </db:form>
        <%-- END: HTML Form --%>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
 
