<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function setWorkloadOptions()
{
    document.access.wkldRepos.disabled= !document.access.workloadOption[1].checked;
    //document.access.workloadTable.disabled= !document.access.workloadOption[2].checked;
    //document.access.hypoSchema.disabled= !document.access.workloadOption[3].checked;
    document.access.hypoSchema.disabled= !document.access.workloadOption[2].checked;
    if (document.access.workloadFilterSelected != null)
        setFilterOptions();
}
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>
<uix:renderingContext id="renderingContext">
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<%@ include file="/oemTitle.jspf" %>

    <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body onLoad="setWorkloadOptions()">

       <%-- HTML Form --%>
       <db:form name="access" 
                method="post" 
                destinationBinding="destination@objectBean@servletRequest" 
                copyParams="target,type,advisoryCentralURL,dbPageNum" >
          <uix:formValue name="pageName" value="/database/sqlaccess/workload"/>
          <uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest" />


<uix:pageLayout titleBinding="WORKLOAD_TITLE@AAMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

    <%-- Display wizard train and Logged in As --%>
    <uix:location>
        <uix:train selectedIndex="0">
            <db:link textBinding="STEP_WORKLOAD@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_METHODS@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="REVI_SCHED@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_REVIEW@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
        </uix:train>
    </uix:location>

     <uix:pageStatus>
       <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
     </uix:pageStatus>
     <%-- Follow page/wizard context information with a separator --%>
     <uix:separator/>

           <%-- Warning/Error display --%>
            <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           
 <uix:stackLayout>
   <uix:rowLayout>
     <uix:cellFormat width="100%" vAlign="top">
 
   <uix:stackLayout>
     <uix:flowLayout>
       <uix:styledText textBinding="WORKLOAD_TEXT1@AAMsgs"  styleClass="OraInstructionText"/>
     </uix:flowLayout>
         <uix:spacer height="5"/>

   </uix:stackLayout>

     <uix:flowLayout>
       <uix:rowLayout>
         <uix:spacer width="10" height="2"/>
         <uix:cellFormat> 
           <uix:radioButton name="workloadOption" 
                            value="<%=AccessParameterConstants.CACHE%>" 
                            selectedValueBinding="workloadOption@objectBean@servletRequest" 
                            shortDescBinding="IMPORT_WKLD_DESC@AAMsgs"
                            onClick='setWorkloadOptions()'
                            textBinding="WORKLOAD_OPTION_BUTTON@AAMsgs" />         
         </uix:cellFormat>
       </uix:rowLayout>
 
         <uix:rowLayout>
           <uix:cellFormat>
             <uix:spacer width="38" height="0" />
             <uix:styledText textBinding="WORKLOAD_OPTION_BUTTON_DESC@AAMsgs" 
                             styleClass="OraInlineInfoText"  />
           </uix:cellFormat>
         </uix:rowLayout>  
       <uix:spacer height="2"/>
        <uix:rowLayout>
           <uix:spacer width="10" height="2"/>
	         <uix:cellFormat >
             <uix:radioButton name="workloadOption" 
                                   value="<%=AccessParameterConstants.SQL_REPOSITORY%>" 
                                   selectedValueBinding="workloadOption@objectBean@servletRequest"
                                   shortDescBinding="IMPORT_WKLD_DESC@AAMsgs"
                                   onClick='setWorkloadOptions()'
                                   textBinding="WKLD_USE_EXISTING_STS@AAMsgs" />
<%--                                   textBinding="WKLD_REPOS@AAMsgs" />  --%>
           </uix:cellFormat>

          </uix:rowLayout>
       <uix:rowLayout>
           <uix:spacer height ="0" width="38"/>

           <uix:cellFormat >
             <uix:messageLovField name="wkldRepos"
                                  rows="1" columns="50"	
                                  promptBinding="WKLD_SQLTUNINGSET@AAMsgs"
                                  searchDescBinding="WKLD_SQLTUNINGSET@AAMsgs"
                                  textBinding = "wkldRepos@objectBean@servletRequest"
                                  onClick="setSearchFilter('schemaName');startLov('wkldRepos', 'ListSTS');return false" />
           </uix:cellFormat>
         </uix:rowLayout>

         <uix:spacer height="2"/>
         <uix:rowLayout>
           <uix:spacer width="10" height="2"/>
	         <uix:cellFormat>
             <uix:radioButton name="workloadOption" 
                                   value="<%=AccessParameterConstants.HYPOTHETICAL%>" 
                                   selectedValueBinding="workloadOption@objectBean@servletRequest" 
                                   shortDescBinding="IMPORT_WKLD_DESC@AAMsgs"
                                   onClick='setWorkloadOptions()'
                                   textBinding="WKLD_HYPO3@AAMsgs" />
           </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:spacer height ="0" width="38"/>
           <uix:cellFormat>
             <uix:styledText textBinding="WKLD_HYPO_DESC@AAMsgs" 
                             styleClass="OraInlineInfoText" />
           </uix:cellFormat>
         </uix:rowLayout>  

         <uix:rowLayout>
           <uix:spacer height ="0" width="38"/>
           <uix:cellFormat>
             <uix:messageTextInput name="hypoSchema"
                                   rows="3" columns="70"	
                                   promptBinding="SCHEMAS_TABLES@AAMsgs"
                                   shortDescBinding="WKLDFLT_TABLIST@AAMsgs"
                                   textBinding="hypoSchema@objectBean@servletRequest"
                                   tipBinding="COMMA@AAMsgs" />
           </uix:cellFormat>
           <uix:cellFormat>
             <uix:spacer height ="0" width="5"/>
             <uix:button textBinding="ADD@AAMsgs"
                         shortDescBinding="ADD@AAMsgs"
                         onClick="if (document.access.workloadOption[2].checked) submitForm(\'access\',1,{\'event\':\'addSchemaTables\'});return false;" />
           </uix:cellFormat>
         </uix:rowLayout>

        <uix:spacer height="5" />

        <uix:rowLayout>
           <uix:spacer height ="0" width="38"/>
             <uix:cellFormat>
<uix:tip>
               <uix:styledText textBinding="WKLD_HYPO_HINT@AAMsgs"  styleClass="OraTipText"  />
</uix:tip>
             </uix:cellFormat>

         </uix:rowLayout>  
     
       </uix:flowLayout>

    </uix:cellFormat>

  </uix:rowLayout>

<uix:spacer height="15"/>
 </uix:stackLayout>

 <uix:hideShowHeader id="workloadHideShow"
                     textBinding="WKLDFLT_FILTER@AAMsgs"
                     disclosedBinding="workloadShowAdvanced@objectBean@servletRequest"
                     formName="access"
                     formSubmitted="true" >

   <%@ include file="workloadFilter.jsp" %>

 </uix:hideShowHeader>

  <uix:spacer height="10"/>
  <uix:tip>
    <uix:styledText textBinding="FILTER_TIP@AAMsgs"  styleClass="OraTipText"  />
  </uix:tip>

 <uix:pageButtons>  
   <uix:pageButtonBar>
     <uix:submitButton textBinding="CANCEL@AAMsgs"
                       shortDescBinding="CANCEL@AAMsgs"
                       name = "event"
                       unvalidated="true"
                       value = "cancel" />
     <uix:navigationBar 
              maxValue="4" minValue="1" name="step" value="1" 
              destinationBinding="destination@objectBean@servletRequest" 
             formSubmitted="true"
             formName="access"/>
    </uix:pageButtonBar>
 </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
