<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<script>
  function lovCallBack(data) {
    f2 = callBackLovField();  
    f1='exportExistSchema';

    if ((i=data.indexOf('".')) > 0)
    {
      document.forms[0][f1].value=data.substring(0,i+1);
      document.forms[0][f2].value = data.substring(i+2, data.length);
    }
    else if ((i=data.indexOf('.')) >= 0)
    {
      document.forms[0][f1].value = data.substring(0,i);
      document.forms[0][f2].value = data.substring(i+1, data.length);
    }
  }
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="statsMsg" class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
  <uix:document>      
    <uix:metaContainer>      
      <uix:head titleBinding="EXPORT_TABLE@statsMsg"/>         
    </uix:metaContainer>      
    <uix:body>      
      <db:form name="exportForm"  method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/export"/>     
        <uix:formValue name="event"/>       
        
        <uix:pageLayout>            
          <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
                  
          <uix:header textBinding="actionMsg@servletRequest"> 
          <uix:stackLayout>

            <uix:radioButton textBinding="EXPORT_EXIST@statsMsg"
                                name="exportType"
                                selectedValueBinding="exportType@defaultBean@servletRequest"
                                value="<%= JspConstants.YES %>"/>
            <uix:flowLayout>
              <uix:spacer width="20" />
              <uix:messagePrompt promptBinding="TABLE_NAME@statsMsg" labeledNodeId="exportExistTable"/> 
              <uix:textInput name="exportExistSchema" textBinding="exportExistSchema@defaultBean@servletRequest" columns="15" />
              <uix:styledText text="."/>
              <uix:lovField id="exportExistTable"
                          name="exportExistTable"  textBinding="exportExistTable@defaultBean@servletRequest"
                          searchDescBinding="TABLE_NAME@statsMsg"
                          onClick="useCallBack();startLov('exportExistTable', 'ListSchemaTable')" />
            </uix:flowLayout>    
            
            <uix:radioButton textBinding="EXPORT_NEW@statsMsg"
                                name="exportType"
                                selectedValueBinding="exportType@defaultBean@servletRequest"
                                value="<%= JspConstants.NO %>"/>
            <uix:flowLayout>
              <uix:spacer width="20" />
              <uix:messagePrompt promptBinding="TABLE_NAME@statsMsg"  labeledNodeId="exportNewTable"/> 
              <uix:textInput name="exportNewSchema" textBinding="exportNewSchema@defaultBean@servletRequest" columns="15" />
              <uix:styledText text="."/>
              <uix:textInput name="exportNewTable" textBinding="exportNewTable@defaultBean@servletRequest" columns="15" />
            </uix:flowLayout>    


          </uix:stackLayout>  
        </uix:header>   
       
        <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button textBinding="CANCEL@dbMsgs" destinationBinding="maintCancelURL@servletRequest"/>
          <uix:submitButton textBinding="OK@dbMsgs"  name="event" value="exeAction"/>
        </uix:pageButtonBar>        
      </uix:pageButtons>  
      

        </uix:pageLayout>

      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

