<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="StatsMsg" class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="extensionForm" method="post" destination="option" copyParams="target,type,cancelURL,sname,oname">    
      <uix:formValue name="pageName" value="/database/stats/extension"/>
      
      <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
                        
  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>    
    <%-- SubTabs --%> 
    <uix:subTabs>
      <uix:subTabBar selectedIndex="1">
        <uix:link textBinding="GENERAL@StatsMsg"
                   onClick="submitForm('extensionForm', true, {event:'goto1'})"/>
        <uix:link textBinding="STATS_EXTENSION@StatsMsg"
                   onClick="submitForm('extensionForm', true, {event:'goto2'})"/>
     </uix:subTabBar>
    </uix:subTabs>
    
    <uix:styledText styleClass="OraInstructionText"
                    textBinding="EXTENSION_DESC@StatsMsg"/>
<%--                    
    <uix:spacer width="5" />
    <uix:styledText styleClass="OraInstructionText"
                    textBinding="STATS_DESC@StatsMsg"/>
--%>
          <uix:table  width="80%"
                       name="extension"
                       tableDataBinding="extensionList@defaultBean@servletRequest"
                       columnFormatsBinding="extensionColFormats@defaultBean@servletRequest"
                       columnHeaderDataBinding="extensionColHeader@defaultBean@servletRequest" 
                       alternateTextBinding = "NO_COL_GRP_FOUND@StatsMsg"
                       blockSizeBinding="extensionBlockSize@defaultBean@servletRequest"
                       valueBinding="extensionVal@defaultBean@servletRequest" 
                       minValueBinding="extensionMinValue@defaultBean@servletRequest" 
                       maxValueBinding="extensionMaxValue@defaultBean@servletRequest"
                       formSubmitted="true" 
                       summaryBinding="STATS_EXTENSION@StatsMsg"> 
                      
             <uix:tableFormat tableBanding="rowBanding"/>                  
             
                <uix:columnHeaderStamp>                
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>                
                <uix:contents>    
                  <uix:dataScope>           
                  <uix:switcher childNameBinding="isReadOnly" >
                    <uix:case name="true">
                       <uix:styledText textBinding="colName" />                    
                    </uix:case>
                    <uix:default>                     
                      <uix:textInput name="colName" columns="80" textBinding="colName" shortDescBinding="COLUMN_GROUP@StatsMsg" />                         
                    </uix:default>
                  </uix:switcher>
                  </uix:dataScope>           
                  <uix:styledText textBinding="colType"/>   
                  <uix:dataScope>           
                   <uix:switcher childNameBinding="isDrop" >
                    <uix:case name="false">
                      <uix:styledText text="" />
                    </uix:case>
                    <uix:default>
                      <uix:image sourceBinding="deleteIcon" shortDescBinding="DELETE@StatsMsg"  onClickBinding="deleteDest" />                      
                    </uix:default>                    
                  </uix:switcher> 
                  </uix:dataScope>           
                </uix:contents>
                <uix:columnFooter>
                  <uix:submitButton textBinding="ADD_COLUMN_GROUPS@StatsMsg" 
                                    shortDescBinding="ADD_COLUMN_GROUPS@StatsMsg" 
                                    name="event" 
                                    value="addColGrp"
                                    />
                </uix:columnFooter>
           </uix:table>    
           
  </uix:subTabLayout> 
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>
                        
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

