<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="StatsMsg" class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="generalForm" method="post" destination="option" copyParams="target,type,cancelURL,sname,oname">    
      <uix:formValue name="pageName" value="/database/stats/general"/>
      
      <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
       
      
            
       <uix:switcher  childNameBinding="showTable@defaultBean@servletRequest">
          <uix:case name="false">    
            <uix:stackLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="SCHEMA_DESC@StatsMsg" renderedBinding="showSchema@defaultBean@servletRequest" />
           <jsp:include page="/database/stats/optionsIncl.jsp" />
           <uix:ref refID="optionsIncl" />
           </uix:stackLayout>
         </uix:case>
         <uix:default>
           <uix:subTabLayout renderedBinding="showTable@defaultBean@servletRequest">  
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="GENERAL@StatsMsg"
                          onClick="submitForm('generalForm', true, {event:'goto1'})"/>
                <uix:link textBinding="STATS_EXTENSION@StatsMsg"
                          onClick="submitForm('generalForm', true, {event:'goto2'})"/>
                 </uix:subTabBar>
            </uix:subTabs>  
              <jsp:include page="/database/stats/optionsIncl.jsp" />
              <uix:ref refID="optionsIncl" />
         
            </uix:subTabLayout> 
         </uix:default>
       </uix:switcher>

  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>
                        
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

