<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="StatsMsg" class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
  <uix:document>      
    <uix:metaContainer>      
      <uix:head titleBinding="CONFIRMATION@dbMsgs"/>         
    </uix:metaContainer>    
   
    <uix:body>      
      <db:form name="inheritForm" method="post" destination="options" copyParams="target,type">       
        <uix:formValue name="event"/>
        <uix:pageLayout messageType="confirmation">
           <uix:styledText styleClass="OraDataText"  textBinding="INHERIT_GLOBAL_DESC1@StatsMsg"/>
                <uix:spacer height="10"/>
            <uix:stackLayout> 
                <uix:contents childDataBinding="tableList@defaultBean@servletRequest">                 
                  <uix:styledText styleClass="OraPromptText"  textBinding="tableName"/>
                </uix:contents>
           </uix:stackLayout> 
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button textBinding="NO@dbMsgs" destinationBinding="backURL@servletRequest"/>
          <uix:submitButton textBinding="YES@dbMsgs"  name="event" value="delete"/>
        </uix:pageButtonBar>
      </uix:pageButtons>
    </uix:pageLayout>
  </db:form>
</uix:body>
</uix:document>
</uix:renderingContext>

