<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<script>
  function lovCallBack(data) {
    f2 = callBackLovField();  
    f1='schema';

    if ((i=data.indexOf('".')) > 0)
    {
      document.forms[0][f1].value=data.substring(0,i+1);
      document.forms[0][f2].value = data.substring(i+2, data.length);
    }
    else if ((i=data.indexOf('.')) >= 0)
    {
      document.forms[0][f1].value = data.substring(0,i);
      document.forms[0][f2].value = data.substring(i+1, data.length);
    }
  }
</script>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="StatsMsg" class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="optionsForm" method="post" destination="options" copyParams="target,type">    
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="OBJECT_PREFS@StatsMsg">
       
           <uix:header textBinding="SEARCH@dbMsgs">
            <uix:stackLayout>
              <uix:rowLayout>
                  <uix:styledText styleClass="OraPromptText" textBinding="SEARCH_DESC1@StatsMsg"/>
              </uix:rowLayout>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right"> 
                    <uix:styledText labeledNodeId="schemaName"
                                    styleClass="OraPromptText" textBinding="SCHEMA_NAME_COLON@dbMsgs"/>
                  </uix:cellFormat>
                  <uix:messageLovField name="schemaName"
                                     id="schemaName"
                                     textBinding="schemaName@defaultBean@servletRequest"
                                     searchDescBinding="SCHEMA_NAME_COLON@dbMsgs"
                                     onClick="startLov('schemaName', 'ListSchema')"/>
                  <uix:messageText messageBinding="schemaName@errors@servletRequest"
                                   messageType="error"/>
               </uix:rowLayout>
               
               <uix:rowLayout>
                 <uix:cellFormat hAlign="right"> 
                   <uix:styledText labeledNodeId="objectName"
                                   styleClass="OraPromptText" textBinding="TABLE_NAME@dbMsgs"/>
                 </uix:cellFormat>
                   <uix:textInput name="objectName" 
                                  id="objectName" textBinding="objectName@defaultBean@servletRequest"/>
                  <uix:messageText messageBinding="objectName@errors@servletRequest"
                                  messageType="error"/>
               </uix:rowLayout>

               <uix:rowLayout> 
                 <uix:cellFormat> 
                   <uix:submitButton textBinding="GO@dbMsgs" 
                                     shortDescBinding="GO@dbMsgs"
                                     onFocus="true" selected="true" name="event" value="search"/>
                 </uix:cellFormat> 
                 </uix:rowLayout> 
            </uix:tableLayout>

            <uix:styledText styleClass="OraInlineInfoText" 
                            textBinding="SEARCH_HINT@dbMsgs" />

        </uix:stackLayout>

        <%-- End of Search Logic --%>
        <uix:separator>
          <uix:spacer height="10"/>
        </uix:separator>

       <uix:tableLayout cellSpacing="5"  width="80%">
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                  <uix:flowLayout>
                    <uix:submitButton textBinding="ADD_TABLE_PREFS@StatsMsg" 
                                      shortDescBinding="ADD_TABLE_PREFS@StatsMsg" 
                                      name="event" 
                                      value="addTable"/>
                    <uix:submitButton textBinding="ADD_SCHEMA@StatsMsg" 
                                      shortDescBinding="ADD_SCHEMA@StatsMsg" 
                                      name="event" 
                                      value="addSchema"/>                                      
                  </uix:flowLayout>                                      
              </uix:cellFormat>
           </uix:rowLayout>
           

           <uix:table  width="80%"
                       name="local"
                       tableDataBinding="localList@defaultBean@servletRequest"
                       columnFormatsBinding="localColFormats@defaultBean@servletRequest"
                       columnHeaderDataBinding="localColHeader@defaultBean@servletRequest" 
                       alternateTextBinding = "NO_TABLE_FOUND@StatsMsg"
                       blockSizeBinding="localBlockSize@defaultBean@servletRequest"
                       valueBinding="localVal@defaultBean@servletRequest" 
                       minValueBinding="localMinValue@defaultBean@servletRequest" 
                       maxValueBinding="localMaxValue@defaultBean@servletRequest"
                       formSubmitted="true" 
                       summaryBinding="OBJECT_PREFS@StatsMsg"> 
                      
             <uix:tableFormat tableBanding="rowBanding"/>                  
             
                <uix:columnHeaderStamp>                
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>                
                <uix:contents>                               
                     <uix:styledText textBinding="owner"/>   
                     <uix:link textBinding="tableName" destinationBinding="tableDest" />   
                </uix:contents>
                 <uix:tableSelection> 
                   <uix:multipleSelection selectedBinding="selected" shortDescBinding="OBJECT_PREFS@StatsMsg">
                      <uix:submitButton textBinding="EDIT_PREFS@StatsMsg" name="event" value="edit" /> 
                      <uix:submitButton textBinding="INHERIT_GLOBAL@StatsMsg" name="event" value="inherit" />
                    </uix:multipleSelection>
                </uix:tableSelection>               
           </uix:table>    
           
        </uix:tableLayout>

           </uix:header>
           
        </uix:header>    
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

