<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<uix:buildTree nodeID="optionsIncl">

<script>
  function lovCallBack(data) {
    f2 = callBackLovField();  
    f1='schema';

    if ((i=data.indexOf('".')) > 0)
    {
      document.forms[0][f1].value=data.substring(0,i+1);
      document.forms[0][f2].value = data.substring(i+2, data.length);
    }
    else if ((i=data.indexOf('.')) >= 0)
    {
      document.forms[0][f1].value = data.substring(0,i);
      document.forms[0][f2].value = data.substring(i+1, data.length);
    }
  }
</script>

  <uix:dataScope>
    <uix:bundle name="statsMsg" class="oracle.sysman.db.rsc.stats.StatsMsg"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
                  
			<uix:tableLayout cellSpacing="5">      
      
        <uix:rowLayout renderedBinding="showMultiTable@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="TABLE_NAME@statsMsg" />
          </uix:cellFormat>         
              <uix:styledText styleClass="OraDataText" textBinding="tableNames@defaultBean@servletRequest"/> 
        </uix:rowLayout>                          

            
              <uix:switcher childNameBinding="isEdit@defaultBean@servletRequest" >
                <uix:case name="true">
                <uix:rowLayout renderedBinding="showTable@defaultBean@servletRequest">    
                  <uix:cellFormat vAlign="top" hAlign="right">
                    <uix:messagePrompt promptBinding="TABLE_NAME@statsMsg"/>               
                  </uix:cellFormat>     
                  <uix:styledText styleClass="OraDataText" textBinding="fullName@defaultBean@servletRequest"/> 
                  </uix:rowLayout>                  
                </uix:case>          
                <uix:default>  
                <uix:rowLayout renderedBinding="showTable@defaultBean@servletRequest">    
                  <uix:cellFormat vAlign="top" hAlign="right">
                    <uix:messagePrompt promptBinding="TABLE_NAME@statsMsg" required="yes"  labeledNodeId="tableName"/>               
                  </uix:cellFormat>     
                  <uix:flowLayout>
                  <uix:textInput name="schema" textBinding="schema@defaultBean@servletRequest" shortDescBinding="SCHEMA@statsMsg" columns="15" />
                  <uix:styledText text="."/>
                  <uix:lovField id="tableName"
                            name="tableName"  textBinding="tableName@defaultBean@servletRequest"
                            searchDescBinding="TABLE_NAME@statsMsg"
                            onClick="useCallBack();startLov('tableName', 'ListStatsSchemaTable')" />
                  </uix:flowLayout>    
                 </uix:rowLayout>                  
               </uix:default>    
              </uix:switcher> 
            
        <uix:rowLayout renderedBinding="showSchema@defaultBean@servletRequest">                
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="SCHEMA@statsMsg" labeledNodeId="schemaName"/>               
          </uix:cellFormat>         
            <uix:flowLayout>              
              <uix:lovField id="schemaName"
                            name="schemaName" textBinding="schemaName@defaultBean@servletRequest"
                            searchDescBinding="SCHEMA@statsMsg"
                            onClick="startLov('schemaName', 'ListSchema')" />
            </uix:flowLayout>    
        </uix:rowLayout>                                  
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="ESTIMATE_PERCENTAGE@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
              <uix:radioButton name="percentageMethod"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="percentageMethod@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
             <uix:radioButton name="percentageMethod"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="percentageMethod@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest"/>                          
             <uix:radioButton name="percentageMethod"
                          textBinding="AUTO_PERCENTAGE@statsMsg"
                          value="<%= JspConstants.DEFAULT_PERCENTAGE %>"
                          selectedValueBinding="percentageMethod@defaultBean@servletRequest" 
                          shortDescBinding="AUTO_PERCENTAGE_TIP@statsMsg"/>
            <uix:radioButton name="percentageMethod"
                          textBinding="COMPUTE_PERCENTAGE@statsMsg"
                          value="<%= JspConstants.ALL_ROWS %>"
                          selectedValueBinding="percentageMethod@defaultBean@servletRequest" 
                          shortDescBinding="COMPUTE_PERCENTAGE_TIP@statsMsg"/>                          
            <uix:contents>
              <uix:radioButton textBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg"
                               name="percentageMethod"
                               selectedValueBinding="percentageMethod@defaultBean@servletRequest"
                               value="<%= JspConstants.ESTIMATE_PERCENTAGE %>"/>
              <uix:spacer width="5"/>
              <uix:textInput name="currentEstimate" shortDescBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg" textBinding="currentEstimate@defaultBean@servletRequest" readOnly="false" maximumLength="10" columns="10">
                <uix:onSubmitValidater>
                  <uix:decimal/>
                </uix:onSubmitValidater>
              </uix:textInput>
            </uix:contents> 
          </uix:flowLayout> 
        </uix:rowLayout> 
        
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="DEGREE_PARALLELISM@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton name="parallelDegree"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="parallelDegree@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
             <uix:radioButton name="parallelDegree"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="parallelDegree@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest"/>  
             <uix:radioButton textBinding="DEGREE_NULL@statsMsg"
                              shortDescBinding="DEGREE_NULL_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@defaultBean@servletRequest"
                              value="<%= JspConstants.NULL_PARALLEL_DEGREE%>"/>
             <uix:radioButton textBinding="AUTO_DEGREE@statsMsg"
                              shortDescBinding="AUTO_DEGREE_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@defaultBean@servletRequest"
                              value="<%= JspConstants.AUTO_PARALLEL_DEGREE%>"/>
                               
             <uix:radioButton textBinding="SYSTEM_DEFAULT@statsMsg"
                              shortDescBinding="DEGREE_DEFAULTED_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@defaultBean@servletRequest"
                              value="<%= JspConstants.DEFAULT_PARALLEL_DEGREE%>"/>
                           

             <uix:contents>
               <uix:radioButton textBinding="DEGREE_DEFINED@statsMsg"
                                name="parallelDegree"
                                selectedValueBinding="parallelDegree@defaultBean@servletRequest"
                                value="<%= JspConstants.DEFINED_PARALLEL_DEGREE %>"/>
               <uix:spacer width="5"/>
               <uix:textInput name="degreeValue" shortDescBinding="DEGREE_DEFINED@statsMsg" textBinding="degreeValue@defaultBean@servletRequest" readOnly="false" maximumLength="10" columns="10">  
                 <uix:onSubmitValidater>
                   <uix:decimal/>
                 </uix:onSubmitValidater>
               </uix:textInput>
               <uix:spacer width="5"/>
            </uix:contents>
          </uix:flowLayout> 
        </uix:rowLayout> 

        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt labeledNodeId="currentGranularity" promptBinding="GRANULARITY@statsMsg"/>                                           
          </uix:cellFormat>        
            <uix:choice id="currentGranularity"
                        name="currentGranularity"
                        selectedValueBinding="currentGranularity@defaultBean@servletRequest">
              <uix:contents>
                <uix:option textBinding="NO_CHANGE@statsMsg" value="<%= JspConstants.NO_CHANGE %>"
                            renderedBinding="showNoChange@defaultBean@servletRequest"/> 
                <uix:option textBinding="INHERIT_GLOBAL@statsMsg" value="<%= JspConstants.INHERIT %>"
                            renderedBinding="showInherit@defaultBean@servletRequest"/>
                <uix:option textBinding="AUTO@statsMsg" value="<%= JspConstants.AUTO_GRANULARITY %>"/>                                         
                <uix:option textBinding="GLOBAL@statsMsg" value="<%= JspConstants.GLOBAL_GRANULARITY %>"/>
                <uix:option textBinding="GLOBAL_AND_PARTITION@statsMsg" value="<%= JspConstants.GLOBAL_AND_PART_GRANULARITY %>"/>
                <uix:option textBinding="ALL@statsMsg" value="<%= JspConstants.ALL_GRANULARITY %>"/>
                <uix:option textBinding="PARTITION@statsMsg" value="<%= JspConstants.PART_GRANULARITY %>"/>
                <uix:option textBinding="SUBPARTITION@statsMsg" value="<%= JspConstants.SUBPART_GRANULARITY %>"/>
              </uix:contents>
           </uix:choice>   
        </uix:rowLayout> 
        
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="INVALIDATE_CURSORS@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton name="invalidateCur"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="invalidateCur@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
            <uix:radioButton name="invalidateCur"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="invalidateCur@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest" />            
            <uix:radioButton textBinding="INVALIDATE_AUTO@statsMsg"
                             shortDescBinding="INVALIDATE_AUTO_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@defaultBean@servletRequest"
                             value="<%= JspConstants.INVALIDATE_AUTO_OPT%>"/>                               
            <uix:radioButton textBinding="INV_CURSORS@statsMsg"
                             shortDescBinding="INV_CURSORS_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@defaultBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="NOT_INV_CURSORS@statsMsg"
                             shortDescBinding="NOT_INV_CURSORS_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@defaultBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout> 
        
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="CASCADE_OPTION@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton name="cascade"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="cascade@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
            <uix:radioButton name="cascade"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="cascade@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest" />               
            <uix:radioButton textBinding="CASCADE_AUTO@statsMsg"
                             shortDescBinding="CASCADE_AUTO_TIP@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@defaultBean@servletRequest"
                             value="<%= JspConstants.CASCADE_AUTO_OPT%>"/>                              
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@defaultBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@defaultBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>

          </uix:flowLayout> 
        </uix:rowLayout> 

        <uix:rowLayout renderedBinding="showTargetObjectClass@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="TARGET_OBJ@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
           <uix:radioButton name="targetObjectClass"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="targetObjectClass@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
            <uix:radioButton name="targetObjectClass"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="targetObjectClass@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest" /> 
            <uix:radioButton textBinding="TARGET_OBJECT_CLASS_AUTO@statsMsg"
                             shortDescBinding="TARGET_OBJECT_CLASS_AUTO_TIP@statsMsg"
                             name="targetObjectClass"
                             selectedValueBinding="targetObjectClass@defaultBean@servletRequest"
                             value="<%= JspConstants.TARGET_OBJECT_CLASS_AUTO%>"/>
            <uix:radioButton textBinding="TARGET_OBJECT_CLASS_ALL@statsMsg"
                             shortDescBinding="TARGET_OBJECT_CLASS_ALL_TIP@statsMsg"
                             name="targetObjectClass"
                             selectedValueBinding="targetObjectClass@defaultBean@servletRequest"
                             value="<%= JspConstants.TARGET_OBJECT_CLASS_ALL%>"/>
            <uix:radioButton textBinding="TARGET_OBJECT_CLASS_ORACLE@statsMsg"
                             shortDescBinding="TARGET_OBJECT_CLASS_ORACLE_TIP@statsMsg"
                             name="targetObjectClass"
                             selectedValueBinding="targetObjectClass@defaultBean@servletRequest"
                             value="<%= JspConstants.TARGET_OBJECT_CLASS_ORACLE%>"/>
                                                                   
        
          </uix:flowLayout> 
        </uix:rowLayout> 

        <uix:rowLayout renderedBinding="showStalePercentage@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="STALE_PERCENTAGE@statsMsg" labeledNodeId="currentStalePercentage"/>
          </uix:cellFormat>        
          <uix:flowLayout>
             <uix:radioButton name="stalePercentage"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="stalePercentage@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
             <uix:radioButton name="stalePercentage"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="stalePercentage@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest"/>                    
          
            <uix:contents>
              <uix:radioButton textBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg"
                               name="stalePercentage"
                               selectedValueBinding="stalePercentage@defaultBean@servletRequest"
                               value="<%= JspConstants.ESTIMATE_PERCENTAGE %>"/>
              <uix:spacer width="5"/>
              <uix:textInput id="currentStalePercentage" name="currentStalePercentage" 
                           textBinding="currentStalePercentage@defaultBean@servletRequest" 
                           maximumLength="10" columns="10" readOnly="false">  
              <uix:onSubmitValidater>
                <uix:decimal/>
              </uix:onSubmitValidater>                           
            </uix:textInput>   
          </uix:contents> 
          </uix:flowLayout> 
        </uix:rowLayout> 

        <uix:rowLayout renderedBinding="showIncremental@defaultBean@servletRequest">         
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="INCREMENTAL_OPTION@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
              <uix:radioButton name="incremental"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="incremental@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
             <uix:radioButton name="incremental"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="incremental@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest"/>          
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="incremental"
                             selectedValueBinding="incremental@defaultBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="incremental"
                             selectedValueBinding="incremental@defaultBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout> 
        
        <uix:rowLayout renderedBinding="showPublish@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="PUBLISH_OPTION@statsMsg" />            
          </uix:cellFormat>        
          <uix:flowLayout>  
              <uix:radioButton name="publish"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="publish@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
             <uix:radioButton name="publish"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="publish@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest"/>                    
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="publish"
                             selectedValueBinding="publish@defaultBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="publish"
                             selectedValueBinding="publish@defaultBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout> 

        <uix:rowLayout renderedBinding="showCreateHistOptions@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="CREATE_HIST@statsMsg"  labeledNodeId="createHist"/>
          </uix:cellFormat>              
            <uix:flowLayout>  
            <uix:tableLayout>
              <uix:rowLayout>
              <uix:cellFormat vAlign="top" >
             <uix:radioButton name="methodOpt"
                          textBinding="NO_CHANGE@statsMsg"
                          value="<%= JspConstants.NO_CHANGE %>"
                          selectedValueBinding="methodOpt@defaultBean@servletRequest" 
                          shortDescBinding="NO_CHANGE@statsMsg"
                          renderedBinding="showNoChange@defaultBean@servletRequest"/>
             <uix:radioButton name="methodOpt"
                          textBinding="INHERIT_GLOBAL@statsMsg"
                          value="<%= JspConstants.INHERIT %>"
                          selectedValueBinding="methodOpt@defaultBean@servletRequest" 
                          shortDescBinding="INHERIT_GLOBAL@statsMsg"
                          renderedBinding="showInherit@defaultBean@servletRequest"/>                    
            <uix:radioButton name="methodOpt"
                             selectedValueBinding="methodOpt@defaultBean@servletRequest"
                             shortDescBinding="CREATE_HIST@statsMsg"
                             value="<%= JspConstants.TRUE_OPT%>"/>   
            </uix:cellFormat>                             
            <uix:textInput id="createHist" name="createHist" textBinding="createHist@defaultBean@servletRequest" columns="35" readOnly="false" rows="4" wrap="soft" />  
            
              </uix:rowLayout>
            </uix:tableLayout>
            
            </uix:flowLayout>               
        </uix:rowLayout>         
      </uix:tableLayout> 
  </uix:dataScope>
</uix:buildTree>

          
