<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        statsAutoObjProc.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Auto job objects processed in last run page
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   06/22/04 - Add status 
  --   mnihalan   06/18/04 - Initial Creation
  
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/statsAutoObjProc"/>
        <uix:pageLayout titleBinding="AUTO_OBJECTS_ANALYZED@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
                


          <uix:separator/>    

          <uix:contents>
                <uix:labeledFieldLayout labelWidth="15%"> 
                 <uix:contents> 
                                                                                                     
                        <uix:messagePrompt labeledNodeId="searchType" promptBinding="TYPE@statsMsg"/>
                            <uix:choice
                                id="searchType"
                                name="searchType"
                                selectedValueBinding="searchType@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ALL_TYPES@statsMsg" valueBinding="ALL_TYPES@statsMsg"/>
                                    <uix:option textBinding="TABLES@statsMsg" value="<%=JspConstants.TABLES %>"/>
                                    <uix:option textBinding="TABLE_PARTS@statsMsg" value="<%=JspConstants.TABLE_PARTS %>"/>   
                                    <uix:option textBinding="INDEXES@statsMsg" value="<%=JspConstants.INDEXES %>"/>
                                    <uix:option textBinding="INDEX_PARTS@statsMsg" value="<%=JspConstants.INDEX_PARTS%>"/>
                                </uix:contents>
                            </uix:choice>
                            
                        
                        <uix:messagePrompt labeledNodeId="searchSchema" promptBinding="SCHEMA@statsMsg"/>    
                        <uix:lovField
                            id="searchSchema"
                            name="searchSchema"
                            columns="30"
                            searchDescBinding="SCHEMA@statsMsg"
                            textBinding="searchSchema@defaultBean@servletRequest"
                            onClick = "startLov('searchSchema', 'ListSchema')"/>
                          
                        <uix:messagePrompt labeledNodeId="searchObjectName" promptBinding="OBJECT_NAME@statsMsg"/>
                         <uix:textInput
                            id="searchObjectName"
                            name="searchObjectName"
                            textBinding="searchObjectName@defaultBean@servletRequest"
                            columns="30"/>
                    
                        <uix:messagePrompt labeledNodeId="searchPartitionName" promptBinding="PARTITION_NAME@statsMsg"/>
                        <uix:textInput
                            id="searchPartitionName"
                            name="searchPartitionName"
                            textBinding="searchPartitionName@defaultBean@servletRequest"
                            columns="30"/>

                        <uix:messagePrompt labeledNodeId="searchSubPartitionName" promptBinding="SUBPARTITION_NAME@statsMsg"/>
                        <uix:textInput
                            id="searchSubPartitionName"
                            name="searchSubPartitionName"
                            textBinding="searchSubPartitionName@defaultBean@servletRequest"
                            columns="30"/>
                        
                         <uix:messagePrompt labeledNodeId="objectStatus" promptBinding="REPORT_OBJECT_STATUS@statsMsg"/>
                            <uix:choice
                                id="objectStatus"
                                name="objectStatus"
                                selectedValueBinding="objectStatus@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ALL_TYPES@statsMsg" valueBinding="ALL_TYPES@statsMsg"/>
                                    <uix:option textBinding="PENDING@statsMsg" value="<%=JspConstants.PENDING %>"/>
                                    <uix:option textBinding="BEING_PROC@statsMsg" value="<%=JspConstants.BEING_PROC %>"/>   
                                    <uix:option textBinding="COMPLETED@statsMsg" value="<%=JspConstants.COMPLETED %>"/>
                                    <uix:option textBinding="TIMEOUT@statsMsg" value="<%=JspConstants.TIMEOUT%>"/>
                                    <uix:option textBinding="ERROR@statsMsg" value="<%=JspConstants.ERROR%>"/>
                                </uix:contents>
                        </uix:choice>
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton
                        name="event"
                        value="<%= JspConstants.AUTO_OBJECTS_SEARCH %>"
                        textBinding="SEARCH@statsMsg"/>
        
                  </uix:contents>
                </uix:labeledFieldLayout> 
             </uix:contents> 


            <uix:separator/> 
            
            <uix:contents>
            <uix:dataScope currentDataBinding="statsAutoObjProcBean@servletRequest">
                  <jsp:include page="statsAutoObjProcTable.jsp" />                
                  <uix:ref refID="statsAutoObjProcTable" />
            </uix:dataScope>

           </uix:contents>      
     

          
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
