<%--
  -- Page:        statsAutoObjProcTable.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schema Objects table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   03/17/05 - Change from server review 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   06/18/04 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:buildTree nodeID="statsAutoObjProcTable">
  <uix:table name="tableList" 
                       alternateTextBinding="alternateText@"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
		       summaryBinding="SCHEMA_OBJECT_TABLE@statsMsg"
                       blockSize="25">
                
                 <uix:tableFormat tableBanding="rowBanding"/> 

                 <uix:tableSelection>
                  
                         <uix:singleSelection selectedIndexBinding="selectedIndex@" shortDescBinding="SELECT_SCHEMA_OBJECT@statsMsg">
                              <uix:messagePrompt labeledNodeId="actionType" promptBinding="REPORT_ACTION@statsMsg"/>
                                <uix:spacer width="5"/>
                                <uix:choice
                                id="actionType"
                                name="actionType"
                                selectedValueBinding="actionType@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ACTION_GATHER@statsMsg" value="<%= JspConstants.GATHER %>"/>
                                    <uix:option textBinding="ACTION_RESTORE@statsMsg" value="<%= JspConstants.RESTORE %>"/>
                                    <uix:option textBinding="ACTION_DELETE@statsMsg" value="<%= JspConstants.DELETE %>"/>   
                                    <uix:option textBinding="ACTION_LOCK@statsMsg" value="<%= JspConstants.LOCK %>"/>
                                    <uix:option textBinding="ACTION_UNLOCK@statsMsg" value="<%= JspConstants.UNLOCK %>"/>
                                </uix:contents>
                               </uix:choice>
                               <uix:submitButton
                                      name="event"
                                      value="<%= JspConstants.LAUNCH_WIZARD_CONTEXT %>"
                                      textBinding="GO@dbMsgs"/>
                          </uix:singleSelection>
                </uix:tableSelection>
                 
                 <%-- Object Type --%>
                 <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OBJECT_TYPE@statsMsg" sortableBinding="<%= StatsConstants.SORT_OBJECT_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OBJECT_TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                 <%-- OPERATION column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SCHEMA_OBJECTS_NAME@statsMsg" sortableBinding="<%= StatsConstants.SORT_SCHEMA_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.SCHEMA_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  
                  <%-- Object Status column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OBJECT_STATUS@statsMsg" sortableBinding="<%= StatsConstants.SORT_OBJECT_STATUS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OBJECT_STATUS_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <%-- Reason for analysis column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_REASON@statsMsg" sortableBinding="<%= StatsConstants.SORT_REASON_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.REASON_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
  
                 </uix:table>
</uix:buildTree>
