<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizPreferences.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Edit DEfault Parameter Values page
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      11/21/06 - Fix ada
  --   ychan      10/06/06 - Fix error
  --   ychan      10/05/06 - Change ui
  --   sshastry   03/20/06 - 
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   04/06/05 - Add search sub header 
  --   mnihalan   03/21/05 - Change header 
  --   mnihalan   06/15/04 - Add search 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   04/09/04 - mnihalan_opt_stats4 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/03 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js"/>
<script language="javascript">
function enableOrDisableReport()
{
    obj = eval(document.forms[0].objectStatus); 
    bEnabled = eval(obj[obj.selectedIndex].value != "analyzed"); 
    document.forms[0].reportLast.disabled  = bEnabled;
    document.forms[0].reportLastUnit.disabled = bEnabled;
}

function enableOrDisableObjectType()
{
    obj = eval(document.forms[0].publish); 
    bEnabled = eval(obj[obj.selectedIndex].value != "YES"); 
    document.forms[0].objectStatus.disabled  = bEnabled;
    if (bEnabled)
    {
      document.forms[0].reportLast.disabled  = bEnabled;
      document.forms[0].reportLastUnit.disabled = bEnabled;
    }      
}

</script>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="enableOrDisableReport()">
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/statsReportObjAnalyzed"/>
        <uix:pageLayout titleBinding="OBJECT_STATS@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
                


          <uix:separator/>    

          <uix:contents>
	     <uix:header textBinding="SEARCH@statsMsg">

                <uix:labeledFieldLayout labelWidth="15%"> 
                 <uix:contents> 
                         <uix:messagePrompt labeledNodeId="objectStatus" promptBinding="REPORT_OBJECT_STATUS@statsMsg"/>
                            <uix:choice
                                id="objectStatus" 
                                name="objectStatus"
                                onChange="enableOrDisableReport()"
                                selectedValueBinding="objectStatus@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ALL_TYPES@statsMsg" value="<%=JspConstants.ALL %>"/>
                                    <uix:option textBinding="REPORT_OBJECT_ANALYZED@statsMsg" value="<%=JspConstants.ANALYZED %>"/>
                                    <uix:option textBinding="REPORT_OBJECT_STALE@statsMsg" value="<%=JspConstants.STALE %>"/>   
                                    <uix:option textBinding="REPORT_OBJECT_MISSING@statsMsg" value="<%=JspConstants.MISSING %>"/>
                                    <uix:option textBinding="REPORT_OBJECT_LOCKED@statsMsg" value="<%=JspConstants.LOCKED%>"/>
                                </uix:contents>
                        </uix:choice>
                            
                            
                        <uix:messagePrompt labeledNodeId="reportLast" promptBinding="REPORT_LAST@statsMsg"/>
                        <uix:flowLayout>
                            <uix:textInput id="reportLast" name="reportLast" textBinding="reportLast@defaultBean@servletRequest" readOnly="false" maximumLength="10" columns="10">  
                              <uix:onSubmitValidater>
                                <uix:decimal/>
                              </uix:onSubmitValidater>
                            </uix:textInput>
                            <uix:spacer width="5"/>
                                    <uix:choice
                                       name="reportLastUnit"
				       shortDescBinding="REPORT_HOURS@statsMsg"
                                       selectedValueBinding="reportLastUnit@defaultBean@servletRequest">
                                      <uix:contents>
                                           <uix:option textBinding="REPORT_HOURS@statsMsg" value="<%= JspConstants.UNIT_HOURS%>"/>
                                           <uix:option textBinding="REPORT_DAYS@statsMsg" value="<%= JspConstants.UNIT_DAYS %>"/>                                         
                                      </uix:contents>
                                    </uix:choice>
                        </uix:flowLayout>            
                        <uix:messagePrompt labeledNodeId="searchType" promptBinding="TYPE@statsMsg"/>
                            <uix:choice
                                id="searchType"
                                name="searchType"
                                selectedValueBinding="searchType@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ALL_TYPES@statsMsg" value="<%=JspConstants.ALL %>"/>
                                    <uix:option textBinding="TABLES@statsMsg" value="<%=JspConstants.TABLES %>"/>
                                    <uix:option textBinding="TABLE_PARTS@statsMsg" value="<%=JspConstants.TABLE_PARTS %>"/>   
                                    <uix:option textBinding="INDEXES@statsMsg" value="<%=JspConstants.INDEXES %>"/>
                                    <uix:option textBinding="INDEX_PARTS@statsMsg" value="<%=JspConstants.INDEX_PARTS%>"/>
                                </uix:contents>
                            </uix:choice>
                            
                        
                        <uix:messagePrompt labeledNodeId="searchSchema" promptBinding="SCHEMA@statsMsg"/>    
                        <uix:lovField
                            id="searchSchema"
                            name="searchSchema"
                            columns="30"
                            searchDescBinding="SCHEMA@statsMsg"
                            textBinding="searchSchema@defaultBean@servletRequest"
                            onClick = "startLov('searchSchema', 'ListSchema')"/>
                          
                        <uix:messagePrompt labeledNodeId="searchObjectName" promptBinding="OBJECT_NAME@statsMsg"/>
                         <uix:textInput
                            id="searchObjectName"
                            name="searchObjectName"
                            textBinding="searchObjectName@defaultBean@servletRequest"
                            columns="30"/>
                    
                        <uix:messagePrompt labeledNodeId="searchPartitionName" promptBinding="PARTITION_NAME@statsMsg"/>
                        <uix:textInput
                            id="searchPartitionName"
                            name="searchPartitionName"
                            textBinding="searchPartitionName@defaultBean@servletRequest"
                            columns="30"/>

                        <uix:messagePrompt labeledNodeId="searchSubPartitionName" promptBinding="SUBPARTITION_NAME@statsMsg"/>
                        <uix:textInput
                            id="searchSubPartitionName"
                            name="searchSubPartitionName"
                            textBinding="searchSubPartitionName@defaultBean@servletRequest"
                            columns="30"/>
                     
                       <uix:messagePrompt labeledNodeId="publish" promptBinding="TRAIN_SCOPE@statsMsg" 
                                          renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest"/>
                            <uix:choice
                                id="publish"
                                name="publish"
                                renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest"
                                selectedValueBinding="publish@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="CURRENT@dbMsgs" value="<%=JspConstants.YES %>"/>
                                    <uix:option textBinding="PENDING@statsMsg" value="<%=JspConstants.NO %>"/>   
                                    <uix:option textBinding="ALL@statsMsg" value="<%=JspConstants.ALL %>"/>   
                                </uix:contents>
                        </uix:choice>
                     
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton
                        name="event"
                        value="<%= JspConstants.OBJECTS_SEARCH %>"
                        textBinding="GO@dbMsgs"/>
        
                  </uix:contents>
                </uix:labeledFieldLayout> 
            </uix:header>
            </uix:contents> 
            <uix:separator/> 
            
            <uix:contents>
            <uix:dataScope currentDataBinding="statsReportObjAnalyzedBean@servletRequest">
                  <jsp:include page="statsReportObjAnalyzedTable.jsp" />                
                  <uix:ref refID="wizObjAnalyzedTable" />
            </uix:dataScope>

           </uix:contents>      
     

          
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
 
