<%--
  -- Page:        wizSchemaObjectsTable.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schema Objects table
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      10/06/06 - Fix table
  --   ychan      10/05/06 - Change ui
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   03/17/05 - Change block size 
  --   mnihalan   05/19/04 - REmove columns 
  --   mnihalan   04/22/04 - 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:buildTree nodeID="wizObjAnalyzedTable">  
      <uix:table name="tableList" 
                       alternateTextBinding="alternateText@"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       blockSize="25"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
            		       summaryBinding="SCHEMA_OBJECT_TABLE@statsMsg">
                
                 <uix:tableFormat tableBanding="rowBanding"/> 
                 
                <uix:tableSelection>     
                         <uix:singleSelection selectedIndexBinding="selectedIndex@" shortDescBinding="SELECT_SCHEMA_OBJECT@statsMsg"> 
                              <uix:messagePrompt labeledNodeId="actionType" promptBinding="REPORT_ACTION@statsMsg"/>
                                <uix:spacer width="5"/>
                                <uix:choice
                                id="actionType"
                                name="actionType"
                                selectedValueBinding="actionType@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ACTION_GATHER_DESC@statsMsg" value="<%= JspConstants.GATHER %>"/>
                                    <uix:option textBinding="ACTION_RESTORE_DESC@statsMsg" value="<%= JspConstants.RESTORE %>"/>
                                    <uix:option textBinding="ACTION_DELETE_DESC@statsMsg" value="<%= JspConstants.DELETE %>"/>   
                                    <uix:option textBinding="ACTION_LOCK_DESC@statsMsg" value="<%= JspConstants.LOCK %>"/>
                                    <uix:option textBinding="ACTION_UNLOCK_DESC@statsMsg" value="<%= JspConstants.UNLOCK %>"/>
                                    <uix:option textBinding="PUBLISH_OPTION@statsMsg" value="<%= JspConstants.PUBLISH %>" renderedBinding="isPrivateAll@defaultBean@servletRequest"/>
                                    <uix:option textBinding="EXPORT_TABLE@statsMsg" value="<%= JspConstants.EXPORT %>" renderedBinding="isPrivateAll@defaultBean@servletRequest"/>
                                </uix:contents>
                               </uix:choice>
                               <uix:submitButton
                                      name="event"
                                      value="<%= JspConstants.LAUNCH_WIZARD_CONTEXT %>"
                                      textBinding="GO@dbMsgs"/>
                          </uix:singleSelection>                             
                </uix:tableSelection>                                            
                 <%-- Object Type --%>
                 <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OBJECT_TYPE@statsMsg" sortableBinding="<%= StatsConstants.SORT_OBJECT_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OBJECT_TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                 <%-- Objects name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SCHEMA_OBJECTS_NAME@statsMsg" sortableBinding="<%= StatsConstants.SORT_SCHEMA_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.SCHEMA_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <%-- Scope --%>
                  <uix:column renderedBinding="isAll@defaultBean@servletRequest">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="TRAIN_SCOPE@statsMsg" sortableBinding="<%= StatsConstants.SORT_SCOPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.SCOPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <%-- Table Status column --%>
                  <%--
                  <uix:column renderedBinding="isPublish@defaultBean@servletRequest">
                  --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OBJECT_STATUS@statsMsg" sortableBinding="<%= StatsConstants.SORT_OBJECT_STATUS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OBJECT_STATUS_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <%-- Table locked column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OBJECT_LOCKED@statsMsg" sortableBinding="<%= StatsConstants.SORT_OBJECT_LOCKED_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OBJECT_LOCKED_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_LAST_ANALYZED@statsMsg" sortableBinding="<%= StatsConstants.SORT_LAST_ANALYZED_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.LAST_ANALYZED_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                

                   <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_SAMPLE_PCT_USED@statsMsg" sortableBinding="<%= StatsConstants.SORT_SAMPLE_PCT_USED_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.SAMPLE_PCT_USED_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
       </uix:table>
</uix:buildTree>
