<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizPreferences.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Edit DEfault Parameter Values page
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   04/09/04 - mnihalan_opt_stats4 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/03 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/wizPreferences"/>
        <uix:pageLayout titleBinding="REPORT_OBJ_LOCKED_STATS_HDR@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
         <%@ include file="/database/global.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
                

           <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs" 
                           name="event"
                                value="<%= JspConstants.EDIT_CANCEL %>"/>
              
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:separator/>    
        
          <uix:contents>
                <uix:labeledFieldLayout labelWidth="15%"> 
                 <uix:contents>                              
                        <uix:messagePrompt labeledNodeId="searchType" promptBinding="TYPE@statsMsg"/>
                            <uix:choice
                                id="searchType"
                                name="searchType"
                                selectedValueBinding="searchType@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ALL_TYPES@statsMsg" valueBinding="ALL_TYPES@statsMsg"/>
                                    <uix:option textBinding="TABLES@statsMsg" valueBinding="TABLES@statsMsg"/>
                                    <uix:option textBinding="TABLE_PARTS@statsMsg" valueBinding="TABLE_PARTS@statsMsg"/>   
                                    <uix:option textBinding="INDEXES@statsMsg" valueBinding="INDEXES@statsMsg"/>
                                    <uix:option textBinding="INDEX_PARTS@statsMsg" valueBinding="INDEX_PARTS@statsMsg"/>
                                </uix:contents>
                            </uix:choice>
                            
                        
                        <uix:messagePrompt labeledNodeId="searchSchema" promptBinding="SCHEMA@statsMsg"/>    
                         <uix:lovInput
                            id="searchSchema"
                            name="searchSchema"
                            columns="30"
                            textBinding="searchSchema@defaultBean@servletRequest"
                            onLovInit="InitCallBack"
                            destinationBinding="schemaLovDestination@defaultBean@servletRequest"/>
                           
                        <uix:messagePrompt labeledNodeId="searchObjectName" promptBinding="OBJECT_NAME@statsMsg"/>
                         <uix:textInput
                            id="searchObjectName"
                            name="searchObjectName"
                            textBinding="searchObjectName@defaultBean@servletRequest"
                            columns="30"/>
                    
                        <uix:messagePrompt labeledNodeId="searchPartitionName" promptBinding="PARTITION_NAME@statsMsg"/>
                        <uix:textInput
                            id="searchPartitionName"
                            name="searchPartitionName"
                            textBinding="searchPartitionName@defaultBean@servletRequest"
                            columns="30"/>

                        <uix:messagePrompt labeledNodeId="searchSubPartitionName" promptBinding="SUBPARTITION_NAME@statsMsg"/>
                        <uix:textInput
                            id="searchSubPartitionName"
                            name="searchSubPartitionName"
                            textBinding="searchSubPartitionName@defaultBean@servletRequest"
                            columns="30"/>
                     
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton
                        name="event"
                        value="<%= JspConstants.ADD_SCHEMA_OBJECTS_SEARCH %>"
                        textBinding="SEARCH@statsMsg"/>
        
                  </uix:contents>
                </uix:labeledFieldLayout> 
             </uix:contents> 


            <uix:separator/> 
            
            <uix:contents>
           <uix:dataScope currentDataBinding="statsReportObjLockedStatsBean@servletRequest">
              <jsp:include page="statsReportObjLockedStatsTable.jsp" />                
              <uix:ref refID="wizLockedStatsTable" />
            </uix:dataScope>
                        

           </uix:contents>      
     

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
