<%--
  -- Page:        wizSchemaObjectsTable.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schema Objects table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/22/04 - 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:buildTree nodeID="wizLockedStatsTable">
  <uix:table name="tableList" 
                       alternateTextBinding="SCHEMA_NO_OBJECTS@statsMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10">
                
                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:tableSelection>
                        <uix:multipleSelection
                              shortDescBinding="SELECT_SCHEMA_OBJECT@statsMsg"
                              selectedBinding = "<%= StatsConstants.SELECTED_ATTR %>"
                              disabledBinding = "<%= StatsConstants.DISABLED_ATTR %>">
                             <uix:messagePrompt labeledNodeId="action" prompt="Action"/>
                                <uix:spacer width="5"/>
                                <uix:choice
                                id="searchType"
                                name="searchType"
                                selectedValueBinding="actionType@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:option textBinding="ACTION_UNLOCK@statsMsg" valueBinding="<%= JspConstants.UNLOCK %>"/>
                                </uix:contents>
                               </uix:choice>
                               <uix:submitButton
                                      name="event"
                                      value="<%= JspConstants.ADD_SCHEMA_OBJECTS_SEARCH %>"
                                      textBinding="GO@dbMsgs"/>
                          </uix:multipleSelection>
                </uix:tableSelection>
                 
                 <%-- OPERATION column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_SCHEMA@statsMsg" sortableBinding="<%= StatsConstants.SORT_SCHEMA_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.SCHEMA_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OBJECT@statsMsg" sortableBinding="<%= StatsConstants.SORT_OBJECT_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OBJECT_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_PARTITION@statsMsg" sortableBinding="<%= StatsConstants.SORT_PARTITION_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.PARTITION_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_SUBPARTITION@statsMsg" sortableBinding="<%= StatsConstants.SORT_SUBPARTITION_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.SUBPARTITION_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                 

                  <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_LOCK_TYPE@statsMsg" sortableBinding="<%= StatsConstants.SORT_LOCK_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.LOCK_TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_LAST_ANALYZED@statsMsg" sortableBinding="<%= StatsConstants.SORT_LAST_ANALYZED_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.LAST_ANALYZED_ATTR %>"/>
                      </uix:contents>
                  </uix:column>      
                  
                 </uix:table>
</uix:buildTree>