<%--
  -- Page:        wizSchemaObjectsTable.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schema Objects table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/22/04 - 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:buildTree nodeID="wizStatsTable">
  <uix:table name="tableList" 
                       alternateTextBinding="SCHEMA_NO_OBJECTS@statsMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10">
                
                 <uix:tableFormat tableBanding="rowBanding"/> 
                 
                 <%-- OPERATION column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OP_OPERATION@statsMsg" sortableBinding="<%= StatsConstants.SORT_OPERATION_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.OPERATION_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                  <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OP_TARGET@statsMsg" sortableBinding="<%= StatsConstants.SORT_TARGET_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.TARGET_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                    <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OP_START_TIME@statsMsg" sortableBinding="<%= StatsConstants.SORT_START_TIME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.START_TIME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                  <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OP_DURATION@statsMsg" sortableBinding="<%= StatsConstants.SORT_DURATION_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.DURATION_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <%-- Table column type column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REPORT_OP_STATUS@statsMsg" sortableBinding="<%= StatsConstants.SORT_STATUS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.STATUS_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

            
                  
                 </uix:table>
</uix:buildTree>