<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizAction.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Introduction page for the Manage Optimizer Statistics
  --              wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      11/21/06 - Fix ada
  --   ychan      10/05/06 - Change name
  --   ychan      05/18/06 - Add autotask link 
  --   mnihalan   06/09/05 - Sys TIP displayed only for non sys users 
  --   mnihalan   04/01/05 - Add checks for configure 
  --   mnihalan   03/17/05 - Change related links 
  --   shaagarw   01/04/05 - Fix bug 3527994
  --   mnihalan   09/09/04 - Fix enable/disable of configure button 
  --   mnihalan   06/30/04 - Add error checking 
  --   mnihalan   05/12/04 - Fix launch in context 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/26/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/04 - Initital creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="AutoTaskMsg"
            class="oracle.sysman.db.rsc.inst.AutoTaskMsg"/> 
            
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizAction.jsp"/>

        <uix:pageLayout titleBinding="ACTION_HDR@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

            <uix:switcher childNameBinding="displayConfirmation@servletRequest">
                <uix:case name="true">                                     
                  <uix:messageBox automatic="false"
                                  messageBinding="jobAction@servletRequest"
                                  messageType="confirmation">
                    <uix:flowLayout>
                       <uix:styledText textBinding="SCHED_JOB_NAME@statsMsg"
                                        styleClass="OraMessageBoxParagraph"/>
                       <uix:spacer width="5"/> 
                       <uix:link textBinding="displayJobName@servletRequest" 
                              destinationBinding="destPage@servletRequest"/>
                    </uix:flowLayout>
                  </uix:messageBox>
                </uix:case>
          </uix:switcher>
        
         <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
              
         <uix:separator/>    
         
         <uix:contents>
              <uix:styledText textBinding="ACTION_OVERVIEW@statsMsg"
                                      styleClass="OraInstructionText"/>
              <uix:tableLayout width="100%"> 
              <uix:rowLayout vAlign="top">
                <uix:cellFormat renderedBinding="ifVersionNot11OrHigher@defaultBean@servletRequest" vAlign="top" width="60%">
                        <uix:header textBinding="CONFIG_HDR@statsMsg">
                             <uix:styledText textBinding="ACTION_AUTO_JOB@statsMsg"
                                      styleClass="OraInstructionText"/>
                             <uix:stackLayout>
                             <uix:header textBinding="CONFIGURATION@statsMsg">
                                  <uix:tableLayout width="100%">
                                      <uix:rowLayout>
                                            <uix:cellFormat width="100%" hAlign="right">
                                                    <uix:submitButton textBinding="CONFIG_BTN@statsMsg" 
                                                          disabledBinding = "disableConfigureBtn@defaultBean@servletRequest"
                                                          name="event"
                                                          value="<%= JspConstants.CONFIGURE %>"/>                                          
                                            </uix:cellFormat>
                                      </uix:rowLayout>
                                  </uix:tableLayout width="100%"> 
                                  
                                  <uix:labeledFieldLayout labelWidth="50%">
                                  <uix:contents>
                                    <uix:messagePrompt
                                        promptBinding="AUTOMATED_TASK@statsMsg"/>
                                    <uix:styledText
                                        styleClass="OraDataText"
                                        textBinding="autoTaskStatus@defaultBean@servletRequest"/>
                                
                                    <uix:messagePrompt
                                        promptBinding="NEXT_RUN@statsMsg"/>
                                    <uix:styledText textBinding="nextRunDate@defaultBean@servletRequest" 
                                                      styleClass="OraDataText" />
                                    <uix:messagePrompt
                                        promptBinding="WINDOW_NEXT_RUN@statsMsg"/>
                                    <db:link textBinding="nextRunWindow@defaultBean@servletRequest" 
                                            destination="/console/database/stats/stats?event=showWindowDetails" copyParams="target,type,sname,oname,otype"/>
                                    
                                    <uix:messagePrompt
                                        promptBinding="RUN_HISTORY@statsMsg"/>
                                    <uix:switcher childNameBinding="enableConfigure@defaultBean@servletRequest">
                                        <uix:case name="false">
                                            <uix:styledText textBinding="autoJobCount@defaultBean@servletRequest" 
                                                      styleClass="OraDataText" />
                                        </uix:case>
                                        <uix:default>
                                            <db:link textBinding="autoJobCount@defaultBean@servletRequest" 
                                                    
destination="/console/database/instance/schr/jobs?filter=true&pageName=history&sname=SYS&oname=GATHER_STATS_JOB" copyParams="target,type"/>
                                        </uix:default>
                                    </uix:switcher>    
                                    
                                  </uix:contents>
                                </uix:labeledFieldLayout>
                                 <uix:tip renderedBinding = "disableConfigureBtn@defaultBean@servletRequest">
                                    <uix:contents>
                                        <uix:styledText textBinding="SYS_PRIVS2@statsMsg"
                                                            styleClass="OraMessageBoxParagraph"/>
                                    </uix:contents>
                                 </uix:tip> 
                              </uix:header>
                              
                              <uix:header textBinding="LAST_RUN_HDR@statsMsg">
                               <uix:labeledFieldLayout labelWidth="50%">
                                  <uix:contents>
                                
                                    <uix:messagePrompt
                                        promptBinding="LAST_RUN@statsMsg"/>
                                    <uix:switcher childNameBinding="enableConfigure@defaultBean@servletRequest">
                                        <uix:case name="false">
                                          <uix:styledText
                                              styleClass="OraDataText"
                                              textBinding="lastRunDate@defaultBean@servletRequest"/>
                                        </uix:case>
                                        <uix:default>
                                            <db:link textBinding="lastRunDate@defaultBean@servletRequest" 
                                                    destination="/console/database/stats/stats?event=viewLastAutoTask" copyParams="target,type"/>
                                        </uix:default>
                                    </uix:switcher>
                                    
                                    <uix:messagePrompt
                                        promptBinding="LAST_RUN_STATUS@statsMsg"/>
                                    <uix:styledText textBinding="lastRunStatus@defaultBean@servletRequest" 
                                            styleClass="OraDataText" />
                                    
                                    <uix:messagePrompt
                                        promptBinding="RUN_DURATION@statsMsg"/>
                                    <uix:styledText textBinding="lastRunDuration@defaultBean@servletRequest" 
                                            styleClass="OraDataText" />
                                    
                                    <uix:messagePrompt
                                        promptBinding="AUTO_OBJECTS_ANALYZED@statsMsg"/>
                                    
                                        <uix:switcher childNameBinding="countAutoObjProcStr@defaultBean@servletRequest">
                                          <uix:case name="true">
                                            <uix:styledText styleClass="OraDataText"
                                                            textBinding="UNAVAILABLE@statsMsg" />
                                          </uix:case>
                                          <uix:default>
                                              <db:link textBinding="countAutoObjProc@defaultBean@servletRequest" 
                                                         destination="/console/database/stats/stats?event=viewAutoObjProc" copyParams="target,type,sname,oname,cancelURL,otype"/>
                                          </uix:default>
                                        </uix:switcher>
                                  </uix:contents>
                                </uix:labeledFieldLayout>
                              </uix:header>
                              
                             </uix:stackLayout>
                    </uix:header>
                  </uix:cellFormat>
                  <uix:cellFormat vAlign="top" width="40%">
                    <uix:stackLayout>
                        <uix:header textBinding="OPERATIONS@statsMsg">
                          <uix:stackLayout>
                           
                              <db:link textBinding="ACTION_GATHER@statsMsg" 
                                    destinationBinding="gatherStatsLink@servletRequest" copyParams="target,type,sname,oname,cancelURL,otype"/>
                              <db:link textBinding="ACTION_RESTORE@statsMsg" 
                                    destinationBinding="restoreStatsLink@servletRequest" copyParams="target,type,sname,oname,cancelURL,otype"/>        
                              <db:link textBinding="ACTION_LOCK@statsMsg" 
                                    destinationBinding="lockStatsLink@servletRequest" copyParams="target,type,sname,oname,cancelURL,otype"/>
                              <db:link textBinding="ACTION_UNLOCK@statsMsg" 
                                    destinationBinding="unlockStatsLink@servletRequest" copyParams="target,type,sname,oname,cancelURL,otype"/>
                              <db:link textBinding="ACTION_DELETE@statsMsg" 
                                    destinationBinding="deleteStatsLink@servletRequest" copyParams="target,type,sname,oname,cancelURL,otype"/>
                          </uix:stackLayout>  
                        </uix:header>
                   
                         <uix:header textBinding="RELATED_LINK@statsMsg">
                            <uix:stackLayout>
                    
                                   <db:link renderedBinding="ifVersion10GR2OrHigher@defaultBean@servletRequest"
                                            textBinding="OBJECT_STATS@statsMsg" 
                                            destination="/console/database/stats/stats?event=viewReportObjectsAnalyzed" copyParams="target,type,sname,oname,cancelURL,otype"/>
                
                                   <db:link textBinding="ACTION_GATHER_DEFAULTS@statsMsg" 
                                      destinationBinding="gatherStatsDefaultsLink@servletRequest" copyParams="target,type,sname,oname,cancelURL,otype"/>                        
                       
                                   <db:link renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest"
                                            textBinding="OBJECT_PREFS@statsMsg" 
                                            destination="/console/database/stats/options" copyParams="target,type"/>
                       
                                  <db:link textBinding="SCHEDULER_JOB_LINK@statsMsg"                                     
                                      destination="/console/database/instance/schr/jobs?filter=true&pageName=history&sname=SYS&oname=GATHER_STATS_JOB" copyParams="target,type"/>
       
                                  <db:link renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest"
                                           textBinding="AUTOTASK@AutoTaskMsg" 
                                           destination="/console/database/instance/autoTask?event=doLoad" copyParams="target,type,pageName"/>

                            </uix:stackLayout>
                         </uix:header>
                        
                    </uix:stackLayout>
                  </uix:cellFormat>
                 
                </uix:rowLayout>
          
              </uix:tableLayout>
              
        </uix:contents>
           
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
         
