<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizActionPre10g.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Introduction page for the Manage Optimizer Statistics
  --              wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   04/09/04 - mnihalan_opt_stats4 
  --   mnihalan   03/26/04 - Initital creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizActionPre10g.jsp"/>

        <uix:pageLayout titleBinding="ACTION_HDR@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <uix:switcher childNameBinding="displayConfirmation@servletRequest">
                <uix:case name="true">                                     
                  <uix:messageBox automatic="false"
                                  messageBinding="jobAction@servletRequest"
                                  messageType="confirmation">
                    <uix:flowLayout>
                       <uix:styledText textBinding="SCHED_JOB_NAME@statsMsg"
                                        styleClass="OraMessageBoxParagraph"/>
                       <uix:spacer width="5"/> 
                       <uix:link textBinding="displayJobName@servletRequest" 
                              destinationBinding="destPage@servletRequest"/>
                    </uix:flowLayout>
                  </uix:messageBox>
                </uix:case>
          </uix:switcher>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@sdkMsgs" 
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="CONTINUE@sdkMsgs"
                                 name="event"
                                value="<%= JspConstants.LAUNCH_EVENT %>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

         <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
              
         <uix:separator/>    
         
         <uix:contents>
              <uix:styledText textBinding="ACTION_OVERVIEW@statsMsg"
                                      styleClass="OraInstructionText"/>
             
               <uix:stackLayout>
                  <uix:radioButton textBinding="ACTION_GATHER@statsMsg"
                                          name="actionType"
                                          selectedValueBinding="actionType@defaultBean@servletRequest"
                                          value="<%= JspConstants.GATHER %>"/>
                  <uix:radioButton textBinding="ACTION_DELETE@statsMsg" 
                                          name="actionType"
                                          selectedValueBinding="actionType@defaultBean@servletRequest"
                                          value="<%= JspConstants.DELETE %>"/>
                </uix:stackLayout>
        </uix:contents>
           
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
         