<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizAddSchemaTables.jsp
  -- Controller:  oracle.sysman.db.util.sats.StatsController
  --
  -- Description: Page to add a schema object(table) to the selected schema objects
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   07/27/04 - Change table for Add Schema Objects 
  --   mnihalan   06/17/04 - Fix the search 
  --   mnihalan   04/30/04 - Change LOV 
  --   mnihalan   04/12/04 - Add tip 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/01/03 - Initial creation
  --%>
<script language="javascript" src="/em/database/LOV.js"></script>

  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizAddSchemaTables"/>
        <uix:formValue name="pageIndex" value="185"/>
        <uix:formValue name="searchType" value="<%=JspConstants.TABLES %>" />

        <uix:pageLayout titleBinding="beanPageHeader@defaultBean@servletRequest">
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:location>
            <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>                     
          </uix:location>

           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                  <uix:contents>
                    <uix:messagePrompt
                        promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                    <uix:styledText
                        styleClass="OraDataText"
                        textBinding="targetName@defaultBean@servletRequest"/>
                  </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
          
          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <uix:separator/> 
   
            <uix:header textBinding="SEARCH@statsMsg">
              <uix:contents>
                <uix:labeledFieldLayout labelWidth="15%"> 
                 <uix:contents>         
                        <uix:messagePrompt labeledNodeId="searchSchema" promptBinding="SCHEMA@statsMsg"/>    
                        <uix:lovField
                            id="searchSchema"
                            name="searchSchema"
                            columns="30"
			    searchDescBinding="SCHEMA@statsMsg"
                            textBinding="searchSchema@defaultBean@servletRequest"
                            onClick = "startLov('searchSchema', 'ListSchema')"/>
                        <uix:messagePrompt labeledNodeId="searchObjectName" promptBinding="OBJECT_NAME@statsMsg"/>
                         <uix:textInput
                            id="searchObjectName"
                            name="searchObjectName"
                            textBinding="searchObjectName@defaultBean@servletRequest"
                            columns="30"/>
                            
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton
                        name="event"
                        value="<%= JspConstants.ADD_SCHEMA_OBJECTS_SEARCH %>"
                        textBinding="SEARCH@statsMsg"/>
        
                  </uix:contents>
                </uix:labeledFieldLayout> 
             </uix:contents> 
            </uix:header>
            
            <uix:separator/> 
              <uix:contents>
        
              <uix:dataScope currentDataBinding="statsSchemaObjectsBean@servletRequest">
                <jsp:include page="wizAddSchemaObjectsTable.jsp" /> 
                    
                  <uix:ref refID="wizStatsTable" />
                </uix:dataScope>
              </uix:contents>

               <uix:tip>
                    <uix:contents>
                          <uix:styledText textBinding="userPrivsTip@defaultBean@servletRequest"
                                                  styleClass="OraMessageBoxParagraph"/>
                    </uix:contents>
              </uix:tip>

          
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMA_OBJECTS_CANCEL %>"
                    textBinding="CANCEL@sdkMsgs"/>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMA_OBJECTS_OK %>"
                    textBinding="OK@sdkMsgs"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

   
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
