<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizAddSchemas.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Page to add a schema to the selected schemas
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   07/27/04 - Change table to Add Table 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/24/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/19/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

   <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizAddSchemas"/>

        <uix:pageLayout titleBinding="beanPageHeader@defaultBean@servletRequest">

        
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <%--       --%>
          <%-- Train --%>
          <%--       --%>
          <uix:location>
                 <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>                    
          </uix:location>

         <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
          
          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <uix:separator/> 
          
          <uix:header textBinding="SEARCH@statsMsg">
              <uix:contents>
                    <uix:messagePrompt labeledNodeId="searchSchema" promptBinding="NAME@statsMsg"/>
                    <uix:spacer width="5"/>
                    <uix:textInput
                        id="searchSchema"
                        name="searchSchema"
                        textBinding="searchSchema@defaultBean@servletRequest"
                        columns="30"/>
                    <uix:spacer width="5"/>
                     <uix:submitButton
                        name="event"
                        value="<%= JspConstants.ADD_SCHEMA_SEARCH %>"
                        textBinding="SEARCH@statsMsg"/>
              </uix:contents>
            </uix:header>
            
           <uix:separator/> 
              <uix:contents>
        
              <uix:dataScope currentDataBinding="statsSchemaBean@servletRequest">
                <jsp:include page="wizAddSchemaTable.jsp" />                
                  <uix:ref refID="wizStatsTable" />
                </uix:dataScope>

                <uix:switcher childNameBinding="ifVersion10OrHigher@defaultBean@servletRequest">
                    <uix:case name="true">
                       <uix:tip>
                          <uix:contents>
                              <uix:styledText textBinding="USER_PRIVS@statsMsg"
                                                  styleClass="OraMessageBoxParagraph"/>
                          </uix:contents>
                      </uix:tip>
                    </uix:case>
                    <uix:default>
                        <uix:tip>
                            <uix:contents>
                              <uix:styledText textBinding="USER_PRIVS_PRE10G@statsMsg"
                                                  styleClass="OraMessageBoxParagraph"/>
                          </uix:contents>
                      </uix:tip>
                    </uix:default>
                </uix:switcher>
                
              </uix:contents>
           
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMA_CANCEL %>"
                    textBinding="CANCEL@sdkMsgs"/>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMA_OK %>"
                    textBinding="OK@sdkMsgs"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

            
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
