<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizConfigure.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Configure page for Gather Stats automated tasks
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/04 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/wizConfigure"/>
        <uix:pageLayout titleBinding="CONFIGURE_STATS_HDR@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
                

           <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs" 
                           name="event"
                                value="<%= JspConstants.CONFIGURE_CANCEL %>"/>
              <uix:submitButton textBinding="OK@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.CONFIGURE_OK %>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:separator/>    
          
          <uix:contents>
              <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer width="3" height="5"/>
                    </uix:separator>

                    <uix:rowLayout>
                        <uix:contents>
                                <uix:styledText styleClass="OraDataText" textBinding="CONFIGURE_AUTOMATED_TASK@statsMsg"/>                      
                          </uix:contents>
                    </uix:rowLayout>
                    <%-- Configure Automated task --%>
                    <uix:rowLayout>
                      <uix:spacer width="20"/>
                            <uix:radioButton textBinding="ENABLE_AUTOMATED_TASK@statsMsg"
                                            name="autoTaskStatus"
                                            selectedValueBinding="autoTaskStatus@defaultBean@servletRequest"
                                            value="Enabled"/>
                      
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:spacer width="20"/>
                      <uix:radioButton textBinding="DISABLE_AUTOMATED_TASK@statsMsg"
                                              name="autoTaskStatus"
                                              selectedValueBinding="autoTaskStatus@defaultBean@servletRequest"
                                              value="Disabled"/>

                   </uix:rowLayout>
                
                  </uix:stackLayout>
                    
        </uix:contents>
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
