<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSchedule.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schedule page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   02/21/07 - Fix bug 5885460
  --   sshastry   03/20/06 - 
  --   mnihalan   07/22/04 - Change include page 
  --   mnihalan   06/17/04 - Fix navigation 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/30/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   04/08/03 - Change the target name header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/05/03 - Add code
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="schmMsgs"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
  <uix:bundle name="bundle"                   
          class="oracle.sysman.db.rsc.inst.JobsMsg"/>
  <uix:bundle name="ScheduleBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

     <%@ include file="/oemTitle.jspf" %>
     <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
      <script>
      function myCallBack(lovwin, event)
      {          
      }
      function lovCallBack(selectedValue, selectedValue1)
      {                
      	document.forms[0].queueSchema.value=selectedValue;                
	document.forms[0].queueObject.value=selectedValue1;      
	submitForm(document.forms[0].name, true,{event:'getAgent'})  
      }
      </script>
    </uix:metaContainer>


    <uix:body>
        <db:form name="scheduleForm" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
          <uix:formValue name="pageName" value="/database/stats/wizDBSchedule"/>
          <uix:formValue name="event" value=""/>
          <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
            <%@ include file="/database/global.jspf" %>
            
            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	 <uix:location>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
              </uix:switcher>              
          </uix:location>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          	<%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>
            <uix:pageButtons>
               <uix:pageButtonBar>
                  <uix:button textBinding="CANCEL@sdkMsgs" 
                              destinationBinding="maintCancelURL@servletRequest"/>
    
                  <uix:navigationBar name="tableNav"
                                     blockSize="-1"
                                     formSubmitted="true"
                                     formName="scheduleForm"
                                     maxValueBinding="numSteps@defaultBean@servletRequest"
                                     minValue="1"
                                     valueBinding="pageSequence@defaultBean@servletRequest"/>
                  <uix:submitButton textBinding="FINISH@sdkMsgs"
                                    renderedBinding="isLastStep@defaultBean@servletRequest"
                                    name="event"
                                    value="<%= DBJobParams.EVENT_FINISH %>" />
                </uix:pageButtonBar>
            </uix:pageButtons>
      
          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>

          <uix:separator/>  
         
              <uix:spacer width="3" height="20"/>      
              <uix:labeledFieldLayout labelWidth="15%">
                <uix:contents>
                  <uix:messagePrompt
                      labeledNodeId="jobName"
                      promptBinding="SCHED_JOB_NAME@statsMsg"
                      required="yes"/>
                  <uix:textInput
                      id="jobName"
                      name="jobName"
                      textBinding="jobName@defaultBean@servletRequest"
                      columns="60"/>
                  <uix:messagePrompt
                      labeledNodeId="jobDescription"
                      promptBinding="SCHED_JOB_DESC@statsMsg"/>
                  <uix:textInput
                      id="jobDescription"
                      name="jobDescription"
                      textBinding="jobDescription@defaultBean@servletRequest"
                      columns="60"/>
                </uix:contents>
              </uix:labeledFieldLayout>
              <uix:header textBinding="SCHED_OPTIONS_HEADER@statsMsg">
                   <jsp:include page="/database/instance/scheduler/scheduleType.jsp" />                
                    <uix:ref refID="scheduleType" />
              </uix:header>
            


        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

