<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSelectSchemaObjectsDetailed.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Page to select schemas objects in detailed mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      10/04/06 - Change layout
  --   sshastry   03/20/06 - 
  --   mnihalan   06/09/05 - Change Cascade 
  --   mnihalan   03/16/05 - Remov defaults button 
  --   mnihalan   04/13/04 - Change radio buttons 
  --   mnihalan   04/09/04 - Fix bugs 
  --   mnihalan   03/22/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   04/08/03 - Change the header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizOptionsDatabase"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:location>
                  <%@ include file="wizTrain.jsp" %>
          </uix:location>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

         <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
      
          <uix:separator/>    
          
          <%-- Navigation buttons --%>
          <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>

      <uix:tableLayout width="100%"  cellSpacing="5">   
        <uix:rowLayout renderedBinding="supportsGatherOptions@defaultBean@servletRequest">
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="OBJECTS_HDR@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
             <uix:radioButton textBinding="GATHER_OBJECTS_DEFAULT@statsMsg"
                             shortDescBinding="GATHER_OBJECTS_DEFAULT_TIP@statsMsg"
                             name="gatherObjects"
                             renderedBinding="ifVersion9OrHigher@defaultBean@servletRequest"
                             selectedValueBinding="gatherObjects@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.GATHER_OBJECTS_DEFAULT %>"/>
            <uix:radioButton textBinding="GATHER_OBJECTS_ALL@statsMsg"
                             name="gatherObjects"
                             selectedValueBinding="gatherObjects@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.GATHER_OBJECTS_ALL%>"/>            
            <uix:radioButton textBinding="GATHER_OBJECTS_STALE@statsMsg"
                             name="gatherObjects"
                             selectedValueBinding="gatherObjects@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.GATHER_OBJECTS_STALE %>"/>
            <uix:radioButton textBinding="GATHER_OBJECTS_EMPTY@statsMsg"
                             name="gatherObjects"
                             selectedValueBinding="gatherObjects@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.GATHER_OBJECTS_EMPTY %>"/>

          </uix:flowLayout> 
        </uix:rowLayout>
        <%-- Gather SYS objects --%>
        <uix:rowLayout renderedBinding="supportsGatherSysOptions@defaultBean@servletRequest">         
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="GATHER_SYS_OBJECTS@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:checkBox name="gatherSys" 
                          textBinding="GATHER_SYS@statsMsg" 
                          disabledBinding="notSupportsSysStats@defaultBean@servletRequest"                             
                          styleClass="OraPromptText" 
                          checkedBinding="gatherSys@statsGatherOptionsBean@servletRequest"/>
          </uix:flowLayout> 
        </uix:rowLayout>                
        <%-- Estimate Percentage --%>
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="ESTIMATE_PERCENTAGE@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton name="percentageMethod"
                          renderedBinding="ifVersion9OrHigher@defaultBean@servletRequest"
                          textBinding="AUTO_PERCENTAGE@statsMsg"
                          value="<%= JspConstants.DEFAULT_PERCENTAGE %>"
                          selectedValueBinding="percentageMethod@statsGatherOptionsBean@servletRequest" 
                          shortDescBinding="AUTO_PERCENTAGE_TIP@statsMsg"/>
            <uix:radioButton name="percentageMethod"
                          textBinding="COMPUTE_PERCENTAGE@statsMsg"
                          value="<%= JspConstants.ALL_ROWS %>"
                          selectedValueBinding="percentageMethod@statsGatherOptionsBean@servletRequest" 
                          shortDescBinding="COMPUTE_PERCENTAGE_TIP@statsMsg"/>                          
            <uix:contents>
              <uix:radioButton textBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg"
                               name="percentageMethod"
                               selectedValueBinding="percentageMethod@statsGatherOptionsBean@servletRequest"
                               value="<%= JspConstants.ESTIMATE_PERCENTAGE %>"/>
              <uix:spacer width="5"/>
              <uix:textInput name="currentEstimate" shortDescBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg" textBinding="currentEstimate@statsGatherOptionsBean@servletRequest" readOnly="false" maximumLength="10" columns="10">
                <uix:onSubmitValidater>
                  <uix:decimal/>
                </uix:onSubmitValidater>              
              </uix:textInput>
              <uix:spacer width="5"/>
              <uix:messageText messageBinding="PercentageUnchanged@errors@servletRequest" messageType="warning"/>
            </uix:contents> 
          </uix:flowLayout> 
        </uix:rowLayout> 
        <uix:rowLayout renderedBinding="supportsSampleMethod@defaultBean@servletRequest">   
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="SAMPLING@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton textBinding="ROW_SAMPLING@statsMsg"
                             shortDescBinding="ROW_SAMPLING_TIP@statsMsg"
                             name="samplingMethod"
                             selectedValueBinding="samplingMethod@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.ROW_SAMPLE %>"/>
            <uix:radioButton textBinding="BLOCK_SAMPLING@statsMsg"
                             shortDescBinding="BLOCK_SAMPLING_TIP@statsMsg"
                             name="samplingMethod"
                             selectedValueBinding="samplingMethod@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.BLOCK_SAMPLE %>"/>                  
            </uix:flowLayout> 
        </uix:rowLayout>
        
        <%-- Degree --%>
        <uix:rowLayout renderedBinding="supportsDegree@defaultBean@servletRequest">
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="DEGREE_PARALLELISM@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
             <uix:radioButton textBinding="DEGREE_NULL@statsMsg"
                              shortDescBinding="DEGREE_NULL_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@statsGatherOptionsBean@servletRequest"
                              value="<%= JspConstants.NULL_PARALLEL_DEGREE%>"/>

             <uix:radioButton textBinding="AUTO_DEGREE@statsMsg"
                              shortDescBinding="AUTO_DEGREE_TIP@statsMsg"
                              name="parallelDegree"
                              renderedBinding="ifVersion10OrHigher@defaultBean@servletRequest"
                              selectedValueBinding="parallelDegree@statsGatherOptionsBean@servletRequest"
                              value="<%= JspConstants.AUTO_PARALLEL_DEGREE%>"/>
                               
             <uix:radioButton textBinding="SYSTEM_DEFAULT@statsMsg"
                              shortDescBinding="DEGREE_DEFAULTED_TIP@statsMsg"
                              name="parallelDegree"
                              renderedBinding="ifVersion9OrHigher@defaultBean@servletRequest"
                              selectedValueBinding="parallelDegree@statsGatherOptionsBean@servletRequest"
                              value="<%= JspConstants.DEFAULT_PARALLEL_DEGREE%>"/>
                           
             <uix:contents>
               <uix:radioButton textBinding="DEGREE_DEFINED@statsMsg"
                                name="parallelDegree"
                                selectedValueBinding="parallelDegree@statsGatherOptionsBean@servletRequest"
                                value="<%= JspConstants.DEFINED_PARALLEL_DEGREE %>"/>
               <uix:spacer width="5"/>
               <uix:textInput name="degreeValue" shortDescBinding="DEGREE_DEFINED@statsMsg" textBinding="degreeValue@statsGatherOptionsBean@servletRequest" readOnly="false" maximumLength="10" columns="10">  
                 <uix:onSubmitValidater>
                   <uix:decimal/>
                 </uix:onSubmitValidater>
               </uix:textInput>
               <uix:spacer width="5"/>
               <uix:messageText messageBinding="DegreeUnchanged@errors@servletRequest" messageType="warning"/>
            </uix:contents>
          </uix:flowLayout> 
        </uix:rowLayout>  
        
        <%-- Granularity --%>
        <uix:rowLayout renderedBinding="supportsGranularity@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt labeledNodeId="currentGranularity" promptBinding="GRANULARITY@statsMsg"/>                                           
          </uix:cellFormat>        
          <uix:choice id="currentGranularity"
                      name="currentGranularity"
                      selectedValueBinding="currentGranularity@statsGatherOptionsBean@servletRequest">
            <uix:contents childDataBinding="granularityKeys@defaultBean@servletRequest">
              <uix:option textBinding="granularityKey@defaultBean@servletRequest" valueBinding="granularityValue@defaultBean@servletRequest"/> 
            </uix:contents>
          </uix:choice>
        </uix:rowLayout>
        
        <%-- NO INVALIDATE --%>
        <uix:rowLayout renderedBinding="supportsInvalidateCur@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="INVALIDATE_CURSORS@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>  
            <uix:radioButton textBinding="INVALIDATE_AUTO@statsMsg"
                             shortDescBinding="INVALIDATE_AUTO_TIP@statsMsg"
                             renderedBinding="ifVersion10OrHigher@defaultBean@servletRequest"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.INVALIDATE_AUTO_OPT%>"/>                                  
            <uix:radioButton textBinding="INV_CURSORS@statsMsg"
                             shortDescBinding="INV_CURSORS_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>           
            <uix:radioButton textBinding="NOT_INV_CURSORS@statsMsg"
                             shortDescBinding="NOT_INV_CURSORS_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/> 
          </uix:flowLayout> 
        </uix:rowLayout> 
        
        <%-- Cascade --%>
        <uix:rowLayout renderedBinding="supportsCascade@defaultBean@servletRequest">
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="CASCADE_OPTION@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton textBinding="CASCADE_AUTO@statsMsg"
                             shortDescBinding="CASCADE_AUTO_TIP@statsMsg"
                             renderedBinding="ifVersion10OrHigher@defaultBean@servletRequest"
                             name="cascade"
                             selectedValueBinding="cascade@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.CASCADE_AUTO_OPT%>"/>                                 
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@statsGatherOptionsBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout>
        
         <%-- Method Options --%>
        <uix:rowLayout renderedBinding="supportsCreateHistOptions@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="CREATE_HIST@statsMsg"  labeledNodeId="createHist"/>
          </uix:cellFormat>              
            <uix:textInput id="createHist" name="createHist" textBinding="createHist@statsGatherOptionsBean@servletRequest" columns="35" readOnly="false" rows="4" wrap="soft" />  
        </uix:rowLayout>               
      </uix:tableLayout>
                                   
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
         
