<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSelectSchemaObjectsDetailed.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Page to select schemas objects in detailed mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   05/18/04 - Remove checkbox 
  --   mnihalan   04/12/04 - Fix bugs 
  --   mnihalan   03/31/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   04/08/03 - Change the header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="ScheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>


    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizOptionsRestore"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:location>
                 <%@ include file="wizTrain.jsp" %>                  
          </uix:location>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

        <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
      
      
          <uix:separator/>    
          
       
            <%-- Navigation buttons --%>
            <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>

            <uix:stackLayout>
                     <uix:contents>
                        <uix:styledText textBinding="RESTORE_TIMESTAMP_INSTR@statsMsg"
                                      styleClass="OraInstructionText"/>

                        <uix:spacer height="10"/>
                       <uix:labeledFieldLayout labelWidth="30%">
                              <uix:contents>
                                 <uix:messagePrompt 
                                           promptBinding="STATS_HISTORY_AVAILABILITY@statsMsg"/>
                                <uix:styledText textBinding="historyAvailability@defaultBean@servletRequest" 
                                                      styleClass="OraDataText" /> 
                              
                                 <%-- START TIME ZONE --%>
                                 <uix:messagePrompt 
                                           renderedBinding="showTimeZone@statsRestoreTimestampBean@servletRequest"
                                           labeledNodeId="startTimeZoneSB"
                                           promptBinding="TIME_ZONE@ScheduleBundle"/>
                                 <uix:rowLayout>
                                    <uix:contents>
                                     <%-- This is a hack, need this to get it alligned --%>
                                     <uix:spacer width="2"/>
                                     <uix:styledText 
                                             renderedBinding="onlyOneTimeZone@statsRestoreTimestampBean@servletRequest"
                                             styleClass="OraDataText" 
                                             id="startTimeZoneSB"
                                             textBinding="startTimeZoneDisplay@statsRestoreTimestampBean@servletRequest"/>

                                          <uix:choice 
                                               renderedBinding="showMultipleTimeZoneRegions@statsRestoreTimestampBean@servletRequest"
                                               id="startTimeZoneRegionSB"
                                               name="startTimeZoneRegionSB"
                                               shortDescBinding="TIME_ZONE@ScheduleBundle"
                                               selectedValueBinding="startTimeZoneRegionSB@statsRestoreTimestampBean@servletRequest">
                                            <uix:contents childDataBinding="timeZoneRegions@statsRestoreTimestampBean@servletRequest">
                                              <uix:option textBinding="text"
                                                          valueBinding="value"/>
                                            </uix:contents>                               
                                          </uix:choice>

                                          <oem:choice
                                               renderedBinding="showMultipleTimeZoneGMT@statsRestoreTimestampBean@servletRequest"
                                               id="startTimeZoneSB"
                                               name="startTimeZoneSB"
                                               shortDescBinding="TIME_ZONE@ScheduleBundle"
                                               optionsBinding="timeZonesSB@statsRestoreTimestampBean@servletRequest"
                                               selectedValueBinding="startTimeZoneSB@statsRestoreTimestampBean@servletRequest"/>
                                    </uix:contents>
                                 </uix:rowLayout>
                              
                                  <%-- Date --%>
                                  <%-- START DATE --%>
                                  <uix:messagePrompt 
                                       labeledNodeId="startDateSB"
                                       promptBinding="DATE@ScheduleBundle"/> 
                                  <uix:rowLayout>
                                      <uix:contents>
                                          <uix:messageDateField
                                                 id="startDateSB"
                                                 name="startDateSB"
                                                 valueBinding="startDateSB@statsRestoreTimestampBean@pageContext"
                                                 tipBinding="dateTip@statsRestoreTimestampBean@servletRequest"
                                                 shortDescBinding="START_DATE@ScheduleBundle"
                                                 columns="24">
                                            <uix:onSubmitValidater>
                                            <uix:date dateStyle="medium"/> 
                                            </uix:onSubmitValidater>
                                            </uix:messageDateField>
                                      </uix:contents>
                                  </uix:rowLayout>
              

                                  <%-- START HOUR --%>
                                <uix:messagePrompt 
                                   labeledNodeId="startTimeID"
                                   promptBinding="TIME@ScheduleBundle"/>

                                <uix:rowLayout>
                                  <uix:contents>
                                      <uix:spacer width="2"/>
                                      <oem:choice
                                           name="startHourSB"
                                           id="startTimeID"
                                           optionsBinding="hoursSB@statsRestoreTimestampBean@servletRequest" 
                                           shortDescBinding="HOURS@ScheduleBundle"
                                           selectedValueBinding="startHourSB@statsRestoreTimestampBean@servletRequest"/>

                                      <uix:spacer width="5"/>

                                      <%-- START MINUTE --%>
                                      <oem:choice 
                                           name="startMinuteSB" 
                                           shortDescBinding="MINUTES@ScheduleBundle"
                                           optionsBinding="minutesSB@statsRestoreTimestampBean@servletRequest" 
                                           selectedValueBinding="startMinuteSB@statsRestoreTimestampBean@servletRequest"/>

                                      <uix:spacer width="5"/>

                                      <%-- START SECOND --%>
                                      <oem:choice 
                                           name="startSecondSB" 
                                           id="startTimeID"
                                           renderedBinding="showSeconds@statsRestoreTimestampBean@servletRequest" 
                                           shortDescBinding="SECONDS@ScheduleBundle"
                                           optionsBinding="secondsSB@statsRestoreTimestampBean@servletRequest" 
                                           selectedValueBinding="startSecondSB@statsRestoreTimestampBean@servletRequest"/>

                                      <%-- START AM/PM --%>
                                      <oem:radioButton
                                           name="startAmPmSB" 
                                           value="AM_VALUE"
                                           selectedValueBinding="startAmPmSB@statsRestoreTimestampBean@servletRequest"
                                           textBinding="AM_LABEL@ScheduleBundle"
                                           shortDescBinding="AM_LABEL@ScheduleBundle"
                                           styleClass="OraInstructionText" />
                                      <oem:radioButton 
                                           name="startAmPmSB" 
                                           value="PM_VALUE"
                                           selectedValueBinding="startAmPmSB@statsRestoreTimestampBean@servletRequest"
                                           textBinding="PM_LABEL@ScheduleBundle"
                                           shortDescBinding="PM_LABEL@ScheduleBundle"
                                           styleClass="OraInstructionText" />
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:labeledFieldLayout>

                               

                        
                        
                          
                     </uix:contents>
                  </uix:stackLayout>
           
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
         
