<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizPreferences.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Edit DEfault Parameter Values page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   04/07/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/03 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/wizPrefShowSQL"/>
        <uix:pageLayout titleBinding="STATS_OPTIONS_SHOW_SQL@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>

         <uix:separator/>    

          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               <uix:submitButton name="event"
                     value="<%= JspConstants.EDIT_SHOW_SQL_OK %>" 
                     textBinding ="RETURN@statsMsg" />

            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
             <%-- START: TAB CONTENTS starts here --%>
              <uix:stackLayout>
                    <db:sqlDisplay  sqlListBinding="editSQL@defaultBean@servletRequest"/>
              </uix:stackLayout>
                     
          </uix:contents>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
