<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizPreferences.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Edit DEfault Parameter Values page
  --
  --  MODIFIED    (MM/DD/YY)
  --   yma        04/05/07 - Fix bug 5944401 
  --   ychan      11/21/06 - Fix ada
  --   ychan      10/04/06 - Change layout
  --   misun      08/22/06 - fix bug 5399877: add 3 extra options
  --   sshastry   03/20/06 - 
  --   mnihalan   06/09/05 - Change Cascade 
  --   mnihalan   04/06/05 - Add hint text for retention period 
  --   mnihalan   03/17/05 - Server review changes 
  --   mnihalan   08/13/04 - Fix bug 
  --   mnihalan   06/22/04 - Add reset defaults 
  --   mnihalan   04/13/04 - Fix radio buttons 
  --   mnihalan   03/26/04 - Fix bugs 
  --   mnihalan   03/23/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/03 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype,forward">
      <uix:formValue name="pageName" value="/database/stats/wizPreferences"/>
        <uix:pageLayout titleBinding="ACTION_GATHER_DEFAULTS@statsMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
                

           <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs" 
                           name="event"
                                value="<%= JspConstants.EDIT_CANCEL %>"/>
              <uix:submitButton textBinding="SHOWSQL@dbMsgs" 
                                name="event"
                                value="<%= JspConstants.EDIT_SHOW_SQL%>"/>
              <uix:submitButton textBinding="APPLY@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.EDIT_OK %>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:separator/>    
          
          <uix:contents>
                <%-- Statistics History --%>
                <uix:header textBinding="RETENTION@statsMsg"> 
		    <uix:stackLayout>
                      <uix:labeledFieldLayout width="50%">
                            <uix:contents>
                                    <uix:messagePrompt
                                        labeledNodeId="retentionPeriod"
                                        promptBinding="CONFIGURE_RETENTION_PERIOD@statsMsg"/>
                                   <uix:flowLayout>
                                       <uix:textInput
                                            id="retentionPeriod"
                                            name="retentionPeriod"
                                            textBinding="retentionPeriod@editDefaultsBean@servletRequest"
                                            columns="10"/>   
                                        <uix:onSubmitValidater>
                                                  <uix:decimal/>
                                          </uix:onSubmitValidater>                                                                             
                                    </uix:flowLayout>
                            </uix:contents>
                      </uix:labeledFieldLayout>
                      <uix:styledText textBinding="RETENTION_PERIOD_TIP@statsMsg"
                                      styleClass="OraInlineInfoText"/>
		  </uix:stackLayout>
                </uix:header>
                
              <uix:header textBinding="GATHER_STATS_DEFAULTS@statsMsg">
                <uix:stackLayout>
                
                <uix:switcher childNameBinding="ifVersion11OrHigher@defaultBean@servletRequest" >
                  <uix:case name="true">
                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                             <uix:styledText textBinding="EDIT_DEFAULTS_INSTR_11@statsMsg"
                                      styleClass="OraInstructionText"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:submitButton textBinding="RESET_DEFAULTS@statsMsg" 
                                            name="event"
                                            value="<%= JspConstants.RESET_DEFAULTS %>"/>                                          
                          </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout> 
                  </uix:case>
                  <uix:default>
                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                             <uix:styledText textBinding="EDIT_DEFAULTS_INSTR@statsMsg"
                                      styleClass="OraInstructionText"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:submitButton textBinding="RESET_DEFAULTS@statsMsg" 
                                            name="event"
                                            renderedBinding="ifVersion10GR2OrHigher@defaultBean@servletRequest"
                                            value="<%= JspConstants.RESET_DEFAULTS %>"/>                                          
                          </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>                   
                  </uix:default>
               </uix:switcher>
               
      <uix:spacer width="10"/>               
      <uix:tableLayout width="100%"  cellSpacing="5">      
        <%-- Esitmate Percentage --%>                         
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="ESTIMATE_PERCENTAGE@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton name="percentageMethod"
                          textBinding="AUTO_PERCENTAGE@statsMsg"
                          value="<%= JspConstants.DEFAULT_PERCENTAGE %>"
                          selectedValueBinding="percentageMethod@editDefaultsBean@servletRequest" 
                          shortDescBinding="AUTO_PERCENTAGE_TIP@statsMsg"/>
            <uix:radioButton name="percentageMethod"
                          textBinding="COMPUTE_PERCENTAGE@statsMsg"
                          value="<%= JspConstants.ALL_ROWS %>"
                          selectedValueBinding="percentageMethod@editDefaultsBean@servletRequest" 
                          shortDescBinding="COMPUTE_PERCENTAGE_TIP@statsMsg"/>                          
            <uix:contents>
              <uix:radioButton textBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg"
                               name="percentageMethod"
                               selectedValueBinding="percentageMethod@editDefaultsBean@servletRequest"
                               value="<%= JspConstants.ESTIMATE_PERCENTAGE %>"/>
              <uix:spacer width="5"/>
              <uix:textInput name="currentEstimate" shortDescBinding="ESTIMATE_DEFINED_PERCENTAGE@statsMsg" textBinding="currentEstimate@editDefaultsBean@servletRequest" readOnly="false" maximumLength="10" columns="10">
                <uix:onSubmitValidater>
                  <uix:decimal/>
                </uix:onSubmitValidater>              
              </uix:textInput>
              <uix:spacer width="5"/>
              <uix:messageText messageBinding="PercentageUnchanged@errors@servletRequest" messageType="warning"/>
            </uix:contents> 
          </uix:flowLayout> 
        </uix:rowLayout> 
        <%-- Degree --%>
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="DEGREE_PARALLELISM@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
             <uix:radioButton textBinding="DEGREE_NULL@statsMsg"
                              shortDescBinding="DEGREE_NULL_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@editDefaultsBean@servletRequest"
                              value="<%= JspConstants.NULL_PARALLEL_DEGREE%>"/>

             <uix:radioButton textBinding="AUTO_DEGREE@statsMsg"
                              shortDescBinding="AUTO_DEGREE_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@editDefaultsBean@servletRequest"
                              value="<%= JspConstants.AUTO_PARALLEL_DEGREE%>"/>
                               
             <uix:radioButton textBinding="SYSTEM_DEFAULT@statsMsg"
                              shortDescBinding="DEGREE_DEFAULTED_TIP@statsMsg"
                              name="parallelDegree"
                              selectedValueBinding="parallelDegree@editDefaultsBean@servletRequest"
                              value="<%= JspConstants.DEFAULT_PARALLEL_DEGREE%>"/>
                           
             <uix:contents>
               <uix:radioButton textBinding="DEGREE_DEFINED@statsMsg"
                                name="parallelDegree"
                                selectedValueBinding="parallelDegree@editDefaultsBean@servletRequest"
                                value="<%= JspConstants.DEFINED_PARALLEL_DEGREE %>"/>
               <uix:spacer width="5"/>
               <uix:textInput name="degreeValue" shortDescBinding="DEGREE_DEFINED@statsMsg" textBinding="degreeValue@editDefaultsBean@servletRequest" readOnly="false" maximumLength="10" columns="10">  
                 <uix:onSubmitValidater>
                   <uix:decimal/>
                 </uix:onSubmitValidater>
               </uix:textInput>
               <uix:spacer width="5"/>
               <uix:messageText messageBinding="DegreeUnchanged@errors@servletRequest" messageType="warning"/>
            </uix:contents>
          </uix:flowLayout> 
        </uix:rowLayout> 
         <%-- Granularity --%>
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt labeledNodeId="currentGranularity" promptBinding="GRANULARITY@statsMsg"/>                                           
          </uix:cellFormat>        
            <uix:choice id="currentGranularity"
                        name="currentGranularity"
                        selectedValueBinding="currentGranularity@editDefaultsBean@servletRequest">
              <uix:contents>
                <uix:option textBinding="AUTO@statsMsg" value="<%= JspConstants.AUTO_GRANULARITY %>"/>                                         
                <uix:option textBinding="GLOBAL@statsMsg" value="<%= JspConstants.GLOBAL_GRANULARITY %>"/>
                <uix:option textBinding="GLOBAL_AND_PARTITION@statsMsg" value="<%= JspConstants.GLOBAL_AND_PART_GRANULARITY %>"/>
                <uix:option textBinding="ALL@statsMsg" value="<%= JspConstants.ALL_GRANULARITY %>"/>
                <uix:option textBinding="PARTITION@statsMsg" value="<%= JspConstants.PART_GRANULARITY %>"/>
                <uix:option textBinding="SUBPARTITION@statsMsg" value="<%= JspConstants.SUBPART_GRANULARITY %>"/>
              </uix:contents>
           </uix:choice>   
        </uix:rowLayout> 
        <%-- NO INVALIDATE --%>
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="INVALIDATE_CURSORS@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
             <uix:radioButton textBinding="INVALIDATE_AUTO@statsMsg"
                             shortDescBinding="INVALIDATE_AUTO_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.INVALIDATE_AUTO_OPT%>"/>                               
            <uix:radioButton textBinding="INV_CURSORS@statsMsg"
                             shortDescBinding="INV_CURSORS_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="NOT_INV_CURSORS@statsMsg"
                             shortDescBinding="NOT_INV_CURSORS_TIP@statsMsg"
                             name="invalidateCur"
                             selectedValueBinding="invalidateCur@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout>
        <%-- Cascade --%>
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="CASCADE_OPTION@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>                         
            <uix:radioButton textBinding="CASCADE_AUTO@statsMsg"
                             shortDescBinding="CASCADE_AUTO_TIP@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.CASCADE_AUTO_OPT%>"/>                              
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="cascade"
                             selectedValueBinding="cascade@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout>
        
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="TARGET_OBJ@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton textBinding="TARGET_OBJECT_CLASS_AUTO@statsMsg"
                             shortDescBinding="TARGET_OBJECT_CLASS_AUTO_TIP@statsMsg"
                             name="targetObjectClass"
                             selectedValueBinding="targetObjectClass@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TARGET_OBJECT_CLASS_AUTO%>"/>
            <uix:radioButton textBinding="TARGET_OBJECT_CLASS_ALL@statsMsg"
                             shortDescBinding="TARGET_OBJECT_CLASS_ALL_TIP@statsMsg"
                             name="targetObjectClass"
                             selectedValueBinding="targetObjectClass@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TARGET_OBJECT_CLASS_ALL%>"/>
            <uix:radioButton textBinding="TARGET_OBJECT_CLASS_ORACLE@statsMsg"
                             shortDescBinding="TARGET_OBJECT_CLASS_ORACLE_TIP@statsMsg"
                             name="targetObjectClass"
                             selectedValueBinding="targetObjectClass@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TARGET_OBJECT_CLASS_ORACLE%>"/>
          </uix:flowLayout> 
        </uix:rowLayout> 
         <%-- Stale Percentage --%>
        <uix:rowLayout renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="STALE_PERCENTAGE@statsMsg" labeledNodeId="currentStalePercentage"/>
          </uix:cellFormat>        
          <uix:flowLayout>  
            <uix:contents>    
              <uix:textInput id="currentStalePercentage" name="currentStalePercentage" 
                           textBinding="currentStalePercentage@editDefaultsBean@servletRequest" 
                           maximumLength="10" columns="10" readOnly="false">  
              <uix:onSubmitValidater>
                <uix:decimal/>
              </uix:onSubmitValidater>                           
            </uix:textInput>   
          </uix:contents> 
          </uix:flowLayout> 
        </uix:rowLayout> 
        
        <%-- Incremental --%>
        <uix:rowLayout renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest">         
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="INCREMENTAL_OPTION@statsMsg" />
          </uix:cellFormat>        
          <uix:flowLayout>    
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="incremental"
                             selectedValueBinding="incremental@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="incremental"
                             selectedValueBinding="incremental@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout>   
        
         <%-- Publish --%>
        <uix:rowLayout renderedBinding="ifVersion11OrHigher@defaultBean@servletRequest">        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="PUBLISH_OPTION@statsMsg" />            
          </uix:cellFormat>        
          <uix:flowLayout>
            <uix:radioButton textBinding="TRUE_LABEL@statsMsg"
                             name="publish"
                             selectedValueBinding="publish@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.TRUE_OPT%>"/>
            <uix:radioButton textBinding="FALSE_LABEL@statsMsg"
                             name="publish"
                             selectedValueBinding="publish@editDefaultsBean@servletRequest"
                             value="<%= JspConstants.FALSE_OPT%>"/>
          </uix:flowLayout> 
        </uix:rowLayout> 
        <%-- Method Options --%>
        <uix:rowLayout>        
          <uix:cellFormat vAlign="top" hAlign="right">
            <uix:messagePrompt promptBinding="CREATE_HIST@statsMsg"  labeledNodeId="createHist"/>
          </uix:cellFormat>              
            <uix:textInput id="createHist" name="createHist" textBinding="createHist@editDefaultsBean@servletRequest" columns="35" readOnly="false" rows="4" wrap="soft" />  
        </uix:rowLayout>                 
      </uix:tableLayout>   

                  </uix:stackLayout>
                </uix:header>

        </uix:contents>
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
