<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizPreferences.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Edit DEfault Parameter Values page
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   02/18/03 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
   <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/wizPreferences"/>
        <uix:pageLayout title="Manage Optimizer Statistics:View Report">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>
                

           <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs" 
                           name="event"
                                value="<%= JspConstants.EDIT_CANCEL %>"/>
              
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:separator/>    
          
          <uix:contents>
            
                <uix:tableLayout width="100%" >  
                    <uix:rowLayout>
                    <%-- Set Preferences  --%>
                      <uix:stackLayout>
                             <uix:rowLayout>
                                  <uix:spacer width="20"/>
                                    <uix:styledText text="Report Last"
                                        styleClass="OraInstructionText"/>
                                     <uix:spacer width="5"/>
                                    <uix:textInput name="reportLast" textBinding="reportLast@defaultBean@servletRequest" readOnly="false" maximumLength="10" columns="10">  
                                    </uix:textInput>
                                    <uix:spacer width="5"/>
                                    <uix:choice
                                       name="reportLastUnit"
                                       selectedValueBinding="reportLastUnit@defaultBean@servletRequest">
                                      <uix:contents>
                                           <uix:option text="days" value="<%= JspConstants.AUTO_GRANULARITY %>"/>                                         
                                           <uix:option text="hours" value="<%= JspConstants.GLOBAL_GRANULARITY %>"/>
                                      </uix:contents>
                                    </uix:choice>
                                    <uix:spacer width="5"/>
                                    <uix:submitButton text="Generate" 
                                       name="event"
                                            value="<%= JspConstants.EDIT_CANCEL %>"/>
                            </uix:rowLayout>
                            <uix:header textBinding="REPORT_OPERATIONS@statsMsg">
                              <uix:dataScope currentDataBinding="statsReportOperationsBean@servletRequest">
                                  <jsp:include page="statsReportOperationsTable.jsp" />                
                                  <uix:ref refID="wizStatsTable" />
                              </uix:dataScope>
                            </uix:header>

                            <uix:header textBinding="REPORT_ANALYZED_OBJECTS@statsMsg">
                              <uix:dataScope currentDataBinding="statsReportObjAnalyzedBean@servletRequest">
                                  <jsp:include page="statsReportObjAnalyzedTable.jsp" />                
                                  <uix:ref refID="wizObjAnalyzedTable" />
                              </uix:dataScope>
                            </uix:header>

                            <uix:header textBinding="REPORT_STALE_OBJECTS@statsMsg">
                              <uix:dataScope currentDataBinding="statsReportObjStaleStatsBean@servletRequest">
                                  <jsp:include page="statsReportObjStaleStatsTable.jsp" />                
                                  <uix:ref refID="wizStaleStatsTable" />
                              </uix:dataScope>
                        
                            </uix:header>

                            <uix:header textBinding="REPORT_LOCKED_OBJECTS@statsMsg">
                                <uix:dataScope currentDataBinding="statsReportObjLockedStatsBean@servletRequest">
                                  <jsp:include page="statsReportObjLockedStatsTable.jsp" />                
                                  <uix:ref refID="wizLockedStatsTable" />
                              </uix:dataScope>
                            </uix:header>
                      </uix:stackLayout>
                      </uix:rowLayout>
                    </uix:tableLayout>
                                   
        </uix:contents>
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
