<%--
  -- Page:       jobReportTable.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schema Objects table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:buildTree nodeID="wizRestoreTimestampsTable">
  <uix:table name="tableList" 
                       alternateTextBinding="SCHEMA_NO_OBJECTS@statsMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10">
                
                    <uix:tableSelection>
                      <uix:switcher childNameBinding="<%= StatsConstants.SELECT_TYPE_ATTR %>">
                        <uix:case name="<%= StatsConstants.MULTI_SELECT %>">
                          <uix:multipleSelection
                              selectedBinding = "<%= StatsConstants.SELECTED_ATTR %>"
                              disabledBinding = "<%= StatsConstants.DISABLED_ATTR %>">
                          </uix:multipleSelection>
                        </uix:case>
                        <uix:case name="<%= StatsConstants.SINGLE_SELECT %>">
                          <uix:singleSelection selectedIndex="0">
                          </uix:singleSelection>
                        </uix:case>
                      </uix:switcher>
                   </uix:tableSelection>
                 
                 <%-- Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader text="Timestamp" />
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.TIMESTAMP_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                               
                  
                 </uix:table>
</uix:buildTree>