<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSchedule.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schedule page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   05/18/04 - Remove lock statsitcs of objects 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/22/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/10/03 - Initial Creation
  
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
        <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
          <uix:formValue name="pageName" value="/database/stats/wizReview"/>
          <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
           <%@ include file="/oemGlobal.jspf" %>

            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	 <uix:location>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>                
          </uix:location>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          	<%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>

            
          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
           <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>

          <uix:separator/>  
         
              <uix:contents>
                    <uix:styledText textBinding="reviewInstr@defaultBean@servletRequest"
                                          styleClass="OraInstructionText"/>

                    <uix:spacer height="5"/>                      
                    <uix:labeledFieldLayout labelWidth="30%"> 
                        <uix:contents>   
                            
                            <uix:messagePrompt promptBinding="SCHED_JOB_NAME@statsMsg" />
                            <uix:styledText textBinding="jobName@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <uix:messagePrompt promptBinding="SCHED_JOB_DESC@statsMsg"/>
                            <uix:styledText textBinding="jobDescription@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <uix:messagePrompt promptBinding="TRAIN_SCOPE@statsMsg"/>
                            <uix:styledText textBinding="scope@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <uix:messagePrompt promptBinding="SELECTED_OBJECTS@statsMsg" renderedBinding="displaySelectedObjects@defaultBean@servletRequest"/>
                            <uix:styledText textBinding="numRows@statsSelectedObjectsBean@servletRequest"
                                    renderedBinding="displaySelectedObjects@defaultBean@servletRequest"
                                    styleClass="OraDataText" />   
                                
                            <uix:messagePrompt promptBinding="ACTION_FORCE_DELETE@statsMsg" renderedBinding="supportsForce@defaultBean@servletRequest"/>                  
                            <uix:styledText textBinding="forceDeleteDisplay@defaultBean@servletRequest"
                                    renderedBinding="supportsForce@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <uix:messagePrompt promptBinding="RESTORE_FORCE_DESC@statsMsg" renderedBinding="supportsRestoreForce@defaultBean@servletRequest"/>                  
                            <uix:styledText textBinding="restoreForceDisplay@defaultBean@servletRequest"
                                    renderedBinding="supportsRestoreForce@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <uix:messagePrompt promptBinding="lockOperationText@defaultBean@servletRequest" renderedBinding="supportsLockOperation@defaultBean@servletRequest"/>                  
                            <uix:styledText textBinding="lockAfterOpDisplay@defaultBean@servletRequest"
                                    renderedBinding="supportsLockOperation@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <%-- Gather Options --%>
                            <%-- Gather Objects --%>
                            <uix:messagePrompt
                                    renderedBinding="displayGatherObjects@defaultBean@servletRequest"
                                    promptBinding="OBJECTS_HDR@statsMsg"/>
                            <uix:styledText
                                    styleClass="OraDataText"
                                    renderedBinding="displayGatherObjects@defaultBean@servletRequest"                                         
                                    textBinding="gatherObjectsDisplay@statsGatherOptionsBean@servletRequest"/>

                            <%-- Degree of Parallelism --%>   
                            <uix:messagePrompt
                                    renderedBinding="displayDegree@defaultBean@servletRequest"
                                    promptBinding="DEGREE_PARALLELISM@statsMsg"/>
                            <uix:styledText
                                    renderedBinding="displayDegree@defaultBean@servletRequest"
                                    styleClass="OraDataText"
                                    textBinding="parallelDegreeDisplay@statsGatherOptionsBean@servletRequest"/>
                                  
                            <%-- Estimate Percentage --%>  
                            <uix:messagePrompt
                                    renderedBinding="displayEstimatePercentage@defaultBean@servletRequest"
                                    promptBinding="ESTIMATE_PERCENTAGE@statsMsg"/>
                            <uix:styledText
                                    styleClass="OraDataText"
                                    renderedBinding="displayEstimatePercentage@defaultBean@servletRequest"                                   
                                    textBinding="percentageMethodDisplay@statsGatherOptionsBean@servletRequest"/>
                              
                            <uix:messagePrompt promptBinding="RUN_JOBTIME@statsMsg"/>
                            <uix:styledText textBinding="reviewTaskStartDate@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 
                        </uix:contents>
                   </uix:labeledFieldLayout>
                           
          </uix:contents>

        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

