<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSchedule.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schedule page
  --
  --  MODIFIED    (MM/DD/YY)
  --   qsong      09/01/05 - 4370005
  --   mnihalan   03/29/05 - Fix bug 4198708 
  --   mnihalan   03/18/05 - Fix bug 4198708 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   04/08/03 - Change the target name header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/05/03 - Add code
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

     <uix:body>

        <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
          <uix:formValue name="pageName" value="/database/stats/wizSchedule"/>
          <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
           <%@ include file="/oemGlobal.jspf" %>

            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	 <uix:location>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>              
          </uix:location>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          	<%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>

            
          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
           <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>

          <uix:separator/>  
         
          <uix:contents>
              <uix:spacer width="3" height="20"/>      
             
              <uix:labeledFieldLayout labelWidth="15%">
                <uix:contents>
                  <uix:messagePrompt
                      labeledNodeId="jobName"
                      promptBinding="SCHED_JOB_NAME@statsMsg"
                      required="yes"/>
                  <uix:textInput
                      id="jobName"
                      name="<%= JspConstants.JOB_NAME %>"
                      textBinding="jobName@defaultBean@servletRequest"
                      columns="60"/>
                  <uix:messagePrompt
                      labeledNodeId="jobDescription"
                      promptBinding="SCHED_JOB_DESC@statsMsg"/>
                  <uix:textInput
                      id="jobDescription"
                      name="jobDescription"
                      textBinding="jobDescription@defaultBean@servletRequest"
                      columns="60"/>
                </uix:contents>
              </uix:labeledFieldLayout>

               <uix:header textBinding="SCHED_HOST_CRED_HDR@statsMsg" size="2">
                  <uix:rowLayout>
                       <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" textBinding="STEP4_INTRO2@uixAnalyzeBundle@servletRequest"/>
                       </uix:contents>
                    </uix:rowLayout>
                    <uix:spacer height="5"/>
                    <%@ include file="/credentials.jspf"%>
              </uix:header>

                 <uix:tableLayout width="100%" cellSpacing="2">          
                <uix:rowLayout vAlign="top">
                  <uix:header textBinding="SCHED_DB_CRED_HDR@statsMsg">
                    <uix:contents>
                      <uix:labeledFieldLayout labelWidth="25%">
                        <uix:contents>
                          <uix:messagePrompt
                              labeledNodeId="targetName"
                              promptBinding="SCHED_DB_USERNAME@statsMsg"
                              required="yes"/>
                          <uix:textInput
                              id="targetName"
                              name="<%= JspConstants.TARGET_USER_NAME %>"
                              textBinding="targetUserName@defaultBean@servletRequest"
                              noAutoComplete="true"
                              columns="30"/>
                          <uix:messagePrompt
                              labeledNodeId="targetPassword"
                              promptBinding="SCHED_DB_PASSWORD@statsMsg"
                              required="yes"/>
                          <uix:textInput
                              id="targetPassword"
                              name="<%= JspConstants.TARGET_PASSWORD %>"
                              textBinding="secretTargetPassword@defaultBean@servletRequest"
                              secret="true"
                              noAutoComplete="true"
                              columns="30"/>
                       </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:contents>
                  </uix:header>
           
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:header textBinding="SCHED_OPTIONS_HEADER@statsMsg">
                   <%@ include file="/sdk/schedule/schedule.jspf" %>
              </uix:header>
              
                    
      	  </uix:contents>

        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

