<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizScope.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Start page for the Optimizer Statistics
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - To fix translation error
  --   mnihalan   06/09/05 - Add group object type 
  --   mnihalan   03/17/05 - Remove delete instruction 
  --   mnihalan   09/14/04 - Change the intro message displayed for delete 
  --                         operations 
  --   mnihalan   07/27/04 - Add tip for fixed and dictionary objects 
  --   mnihalan   06/22/04 - Add message 
  --   mnihalan   06/19/04 - Fix bugs 
  --   mnihalan   03/24/04 - Fix bugs 
  --   mnihalan   03/19/04 - Fix jsp compile error 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   03/17/04 - 
  --   mnihalan   05/01/03 - Initial creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
      <uix:formValue name="pageName" value="/database/stats/wizScope"/>
      <uix:formValue name="actionType" valueBinding="actionType@defaultBean@servletRequest"/>
        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

           <%-- Train    --%>
          <uix:location>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>              
          </uix:location>
   
          <uix:messages>
                <oem:messageBox
                    messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

        
                
         <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>

           <%-- Navigation buttons --%>
            <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>

            
          <uix:separator/>    
                
          <uix:contents>
                <uix:rowLayout>
                  <uix:cellFormat width="65%" vAlign="top">
                    <%--               --%>
                    <%-- Radio buttons --%>
                    <%--               --%>
                      <uix:stackLayout>
                          <uix:separator>
                            <uix:spacer height="3"/>
                          </uix:separator>
    
                          <uix:styledText textBinding="scopeIntro@defaultBean@servletRequest"
                                              styleClass="OraInstructionText"/>
                
                              <uix:messageRadioSet promptBinding="OBJECT_TYPE@statsMsg"> 
                                  <uix:messageRadioButton  
						textBinding="SCOPE_DATABASE@statsMsg"
                                                    message=" "
                                                    name="launchType"
                                                    selectedValueBinding="launchType@defaultBean@servletRequest"
                                                    renderedBinding="ifOpSupportedByDatabase@defaultBean@servletRequest"
                                                    value="<%= JspConstants.DATABASE %>"
                                                    onClick="if (document.foo.actionType.value == 'gather') submitForm('foo', true, {'event':'refreshOptions'})"/>
                        
                                  <uix:messageRadioButton textBinding="SCOPE_SCHEMA@statsMsg"
                                                    message=" "
                                                    name="launchType"
                                                    selectedValueBinding="launchType@defaultBean@servletRequest"
                                                    renderedBinding="ifOpSupportedBySchema@defaultBean@servletRequest"
                                                    value="<%= JspConstants.SCHEMA %>"
                                                    onClick="if (document.foo.actionType.value == 'gather') submitForm('foo', true, {'event':'refreshOptions'})"/>
                                
                                  <uix:messageRadioButton textBinding="SCOPE_TABLES@statsMsg"
                                                    message=" "
                                                    name="launchType"
                                                    selectedValueBinding="launchType@defaultBean@servletRequest"
                                                    renderedBinding="ifOpSupportedByTables@defaultBean@servletRequest"
                                                    value="<%= JspConstants.TABLES %>"
                                                    onClick="if (document.foo.actionType.value == 'gather') submitForm('foo', true, {'event':'refreshOptions'})"/>
                                
                                  <uix:messageRadioButton textBinding="SCOPE_INDEXES@statsMsg"
                                                    message=" "
                                                    name="launchType"
                                                    selectedValueBinding="launchType@defaultBean@servletRequest"
                                                    renderedBinding="ifOpSupportedByIndexes@defaultBean@servletRequest"
                                                    value="<%= JspConstants.INDEXES %>"
                                                     onClick="if (document.foo.actionType.value == 'gather') submitForm('foo', true, {'event':'refreshOptions'})"/>
                                 
                                  <%-- The fixed object stats feature has been added for 10i database --%>
                                  <uix:messageRadioButton textBinding="SCOPE_FIXED_OBJECTS@statsMsg"
                                                        messageBinding="SCOPE_FIXED_OBJECTS_TIP@statsMsg"
                                                        name="launchType"
                                                        renderedBinding="ifOpSupportedByFixedObjects@defaultBean@servletRequest"
                                                        selectedValueBinding="launchType@defaultBean@servletRequest"
                                                        value="<%= JspConstants.FIXED_OBJECTS %>"
                                                        onClick="if (document.foo.actionType.value == 'gather') submitForm('foo', true, {'event':'refreshOptions'})"/>
                                 
                                 
                                 <%-- The dictionary object stats feature has been added for 10i database --%>
                                  <uix:messageRadioButton textBinding="SCOPE_DICTIONARY_OBJECTS@statsMsg"
                                                    messageBinding="SCOPE_DICTIONARY_OBJECTS_TIP@statsMsg"
                                                    name="launchType"
                                                    renderedBinding="ifOpSupportedByDictionaryObjects@defaultBean@servletRequest"
                                                    selectedValueBinding="launchType@defaultBean@servletRequest"
                                                    value="<%= JspConstants.DICTIONARY_OBJECTS %>"
                                                    onClick="if (document.foo.actionType.value == 'gather') submitForm('foo', true, {'event':'refreshOptions'})"/>
				  </uix:messageRadioSet>
                                 
                                  <uix:spacer height="5"/>
                                  <uix:tip renderedBinding="displayScopeTip@defaultBean@servletRequest">
                                    <uix:contents>
                                        <uix:switcher childNameBinding="ifVersion10OrHigher@defaultBean@servletRequest">
                                              <uix:case name="true"> 
                                                  <uix:styledText textBinding="SCOPE_TIP_10G@statsMsg"
                                                                      styleClass="OraMessageBoxParagraph"/>
                                              </uix:case>
                                              <uix:default>
                                                   <uix:styledText textBinding="SCOPE_TIP@statsMsg"
                                                                      styleClass="OraMessageBoxParagraph"/>
                                              </uix:default>
                                        </uix:switcher>
                                    </uix:contents>
                                  </uix:tip>  
    
                           <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                                <uix:case name="<%= JspConstants.GATHER %>">
                                          <uix:header textBinding="scopeOptionsHeader@defaultBean@servletRequest" renderedBinding="showOptionsSection@defaultBean@servletRequest">
                                               <uix:stackLayout>
                                                  <uix:messageRadioButton textBinding="ORACLE_RECOMMENDED_OPTIONS@statsMsg"
                                                      messageBinding="optionsDesc@defaultBean@servletRequest"
                                                      name="showOptions"
                                                      selectedValueBinding="showOptions@defaultBean@servletRequest"
                                                      value="<%= JspConstants.ORACLE_RECOMMENDED_OPTIONS %>" />
                                                    
                                                 
                                                    <uix:flowLayout>
                                                        <uix:spacer width="20"/>
                                                        <uix:spacer width="20"/>
                                                          <uix:hideShow id="optionsHideShow"
                                                                     undisclosedTextBinding="SCOPE_SHOW_OPTIONS@statsMsg"
                                                                     disclosedTextBinding="SCOPE_HIDE_OPTIONS@statsMsg"
                                                                     disclosedBinding="optionsHideShow@defaultBean@servletRequest"
                                                                     formName="foo"
                                                                     formSubmitted="true">
                                                                           <%@ include file="wizOptionsShow.jsp" %>
                                                          </uix:hideShow>
                                                    </uix:flowLayout>
                                                  <uix:spacer height="10"/>
                                                  <uix:messageRadioButton textBinding="CUSTOMIZE_OPTIONS@statsMsg"
                                                      messageBinding="CUSTOMIZE_OPTIONS_TIP@statsMsg"
                                                      name="showOptions"
                                                      selectedValueBinding="showOptions@defaultBean@servletRequest"
                                                      value="<%= JspConstants.CUSTOMIZE_OPTIONS %>" />
                                                  
                                              </uix:stackLayout>
                                        </uix:header>
    
                              </uix:case>
                              
                              <uix:case name="<%= JspConstants.DELETE %>">
                                <uix:header textBinding="scopeOptionsHeader@defaultBean@servletRequest">
                         
                                  <uix:rowLayout>
                                        <uix:checkBox name="forceDelete" 
                                                textBinding="ACTION_FORCE_DELETE@statsMsg" 
                                                      styleClass="OraPromptText" 
                                                      checkedBinding="forceDelete@defaultBean@servletRequest"/>
    
                                  </uix:rowLayout>
                                </uix:header>
                              </uix:case>
                              <uix:case name="<%= JspConstants.RESTORE %>">
                                 <uix:header textBinding="scopeOptionsHeader@defaultBean@servletRequest">
                                     <uix:rowLayout>
                                        <uix:checkBox name="restoreForce" 
                                                textBinding="RESTORE_FORCE_DESC@statsMsg" 
                                                      styleClass="OraPromptText" 
                                                      checkedBinding="restoreForce@defaultBean@servletRequest"/>
    
                                  </uix:rowLayout>
                                  </uix:header>
                              </uix:case>
                            </uix:switcher>

                        
                      </uix:stackLayout>
                  </uix:cellFormat>
                  
                <%--                                  --%>
                <%-- Overview box for Delete Operation--%>
                <%--                                  --%>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                  <uix:case name="<%= JspConstants.DELETE %>">                                           
                    <uix:cellFormat width="40%" vAlign="top">
                              <uix:contentContainer textBinding="DELETE_WARNING@statsMsg" width="100%">
                                <uix:stackLayout>
                                  <uix:separator>
                                    <uix:spacer width="10" height="7"/>
                                  </uix:separator>
                                  <uix:contents>
                                    
                                    <uix:styledText textBinding="DELETE_INSTR1@statsMsg"
                                                    styleClass="OraInstructionText"/>
				<uix:switcher childNameBinding="ifVersion10OrHigher@defaultBean@servletRequest">
				    <uix:case name="true">
					<uix:stackLayout>
                                  	    <uix:separator>
                                               <uix:spacer width="10" height="7"/>
                                            </uix:separator>
                                    	    <uix:styledText textBinding="DELETE_INSTR2@statsMsg"
                                                    styleClass="OraInstructionText"/>
				 	</uix:stackLayout>
				  </uix:case>
				</uix:switcher>
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:contentContainer>
                      </uix:cellFormat>
                     </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
          
        </uix:contents>
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
