<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSelectSchemas.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Page to select schemas
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   06/22/04 - Change name 
  --   mnihalan   05/19/04 - Add checkbox for lock 
  --   mnihalan   04/20/04 - Add sname oname 
  --   mnihalan   03/24/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/19/03 - Initital creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
       <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
        <uix:formValue name="pageName" value="/database/stats/wizSelectSchemas"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <%--       --%>
          <%-- Train --%>
          <%--       --%>
           <uix:location>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>              
          </uix:location>

        <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

         <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
      
          <uix:separator/>    
          
          <%--                    --%>
          <%-- Navigation buttons --%>
          <%--                    --%>
          <jsp:include page="wizNavigation.jsp" />
          <uix:pageButtons>
                <uix:stackLayout>
                  <uix:ref refID="wizNavigation" />
                  <uix:spacer height="2"/>
                </uix:stackLayout>
          </uix:pageButtons>


        <uix:contents>
              <uix:stackLayout>
                  <uix:separator>
                      <uix:spacer width="1" height="5"/>
                  </uix:separator>

                <uix:contents>
                
                  <%--         --%>
                  <%-- buttons --%>
                  <%--         --%>
                  <uix:tableLayout width="100%" cellSpacing="5">
                    <uix:rowLayout>
                        <uix:styledText styleClass="OraInstructionText"
                                textBinding="schemaAddInstr@defaultBean@servletRequest"/>
                    </uix:rowLayout>
                        
                    <uix:rowLayout>
                      <uix:cellFormat width="100%" hAlign="right">
                        <uix:submitButton name="event"
                                          value="<%= JspConstants.ADD_SCHEMA %>"
                                          textBinding="ADD_OBJECTS@statsMsg"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <%--       --%>
                  <%-- table --%>
                  <%--       --%>
                  <uix:dataScope currentDataBinding="statsSelectedSchemaBean@servletRequest">
                      <jsp:include page="wizSchemaTable.jsp" />                
                      <uix:ref refID="wizStatsTable" />
                  </uix:dataScope>
                  
                  <uix:tableLayout width="100%" cellSpacing="5">
                    <uix:rowLayout>
                        <uix:checkBox name="lockAfterOp" 
                            renderedBinding="supportsLockOperation@defaultBean@servletRequest"
                            textBinding="lockOperationText@defaultBean@servletRequest" 
                            styleClass="OraPromptText" 
                            checkedBinding="lockAfterOp@defaultBean@servletRequest"/>
                    </uix:rowLayout>
                  </uix:tableLayout>

                </uix:contents>
              </uix:stackLayout>
          </uix:contents>
           
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
         