<%--
  -- Page:        wizSchemaObjectsTable.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schema Objects table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.stats.StatsConstants" %>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>

<uix:buildTree nodeID="wizStatsTable">
  <uix:table name="tableList" 
                       alternateTextBinding="SCHEMA_NO_OBJECTS@statsMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10">
                
                 <%-- Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SCHEMA_OBJECTS_NAME@statsMsg" sortableBinding="<%= StatsConstants.SORT_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                  <%-- Table column type column --%>
                  <uix:column renderedBinding="<%= StatsConstants.RENDERED_ATTR %>">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SCHEMA_OBJECTS_TYPE@statsMsg" sortableBinding="<%= StatsConstants.SORT_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <%-- Table column partitioned --%>
                  <uix:column renderedBinding="<%= StatsConstants.RENDERED_ATTR %>">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SCHEMA_OBJECTS_PARTITIONED@statsMsg" sortableBinding="<%= StatsConstants.SORT_PARTITIONED_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.PARTITIONED_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <%-- Table column last analyzed --%>
                  <uix:column renderedBinding="<%= StatsConstants.RENDERED_ATTR %>">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SCHEMA_OBJECTS_LAST_ANALYZED@statsMsg" sortableBinding="<%= StatsConstants.SORT_LAST_ANALYZED_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= StatsConstants.LAST_ANALYZED_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                 </uix:table>
</uix:buildTree>