<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSchedule.jsp
  -- Controller:  oracle.sysman.db.util.stats.StatsController
  --
  -- Description: Schedule page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/29/04 - Fix bugs 
  --   mnihalan   03/17/04 - mnihalan_opt_stats1 
  --   mnihalan   05/10/03 - Initial Creation
  
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.stats.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="statsMsg"
              class="oracle.sysman.db.rsc.stats.StatsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="wizardTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>


    <uix:body>
        <db:form name="foo" method="post" destination="/console/database/stats/stats" copyParams="target,type,sname,oname,cancelURL,otype">
          <uix:formValue name="pageName" value="/database/stats/wizReview"/>
          <uix:pageLayout titleBinding="SHOW_SQL_HDR@statsMsg">
           <%@ include file="/oemGlobal.jspf" %>

            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	 <uix:location>
                <uix:switcher childNameBinding="actionType@defaultBean@servletRequest">
                    <uix:case name="<%=JspConstants.GATHER%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:case name="<%=JspConstants.RESTORE%>">
                        <%@ include file="wizTrain.jsp" %>
                    </uix:case>
                    <uix:default>
                        <%@ include file="wizTrain4Steps.jsp" %>
                    </uix:default>
                </uix:switcher>                
          </uix:location>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
          
          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               <uix:submitButton name="event"
                                 value="<%= JspConstants.SHOW_SQL_OK %>" 
                                 textBinding ="RETURN@statsMsg" />

            </uix:pageButtonBar>
          </uix:pageButtons>
            
        
          <uix:separator/>  
         
              <uix:contents>
                  <%-- START: TAB CONTENTS starts here --%>
                  <uix:stackLayout>
                      <db:sqlDisplay  sqlListBinding="generatedSQL@defaultBean@servletRequest"/>
                  </uix:stackLayout>
              </uix:contents>

        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

