<%@ include file="/sdk/oemTop.jspf" %>

<%--
  -- Page:        addTablespaces.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.ConfigController
  --
  -- Description: Page for adding tablespaces to the fragmentation issues
  --              configuration page.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mnihalan  04/27/05 - Fix ADA bugs 
  --     mnihalan  08/07/03 - UI review changes 
  --     hsu       07/25/03 - change global
  --     jochen    06/12/03 - jochen_recommendations
  --     jochen    06/03/03 - Initial entry
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.util.stgAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.stgAdv.StgAdvPages" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="msgs"
            class="oracle.sysman.db.rsc.stgAdv.StgAdvMsg"/>
<uix:bundle name="shrinkMsgs"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
            class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="foo"
               method="post"
               destination="/console/database/stgAdv/config"
               copyParams="target,type,cancelURL">
        <uix:formValue name="pageName"
                       value="<%= StgAdvPages.ADD_TABLESPACE_PAGE %>"/>
        <uix:pageLayout titleBinding="pageHeader@stgAdvConfigBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%--              --%>
          <%-- Errors       --%>
          <%--              --%>
          <uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%--              --%>
          <%-- Buttons      --%>
          <%--              --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.CANCEL %>" />
              <uix:submitButton textBinding="OK@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.ADD_TS_OK %>" />
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>

            <%--        --%>
            <%-- Search --%>
            <%--        --%>
            <uix:stackLayout>
              <uix:header textBinding="SEARCH@msgs">
                <uix:labeledFieldLayout labelWidth="5%"> 
                  <uix:contents>
                    <uix:messagePrompt promptBinding="TABLESPACE@msgs" labeledNodeId="searchTablespace"/>
                    <uix:flowLayout>
                      <uix:textInput
                          id="searchTablespace"
                          name="searchTablespace"
                          textBinding="searchTablespace@stgAdvConfigBean@servletRequest"
                          columns="30"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton
                          name="event"
                          value="<%= JspConstants.TS_SEARCH %>"
                          textBinding="SEARCH@msgs"/>   
                    </uix:flowLayout>
                </uix:contents>
              </uix:labeledFieldLayout>
              </uix:header>

              <%--                    --%>
              <%-- Tablespaces table  --%>
              <%--                    --%>
              <uix:header textBinding="AVAIL_TS@msgs">
                <uix:table name="tsSearchList"
                           alternateTextBinding="NO_OBJECTS@msgs"
                           formSubmitted="true"
                           width="100%"
			   summaryBinding="OBJECTS_TO_CHECK@msgs"
                           tableDataBinding="tablespaceSearchData@stgAdvConfigBean@servletRequest"
                           minValue="1"
                           maxValueBinding="numSearchTablespaces@stgAdvConfigBean@servletRequest"
                           valueBinding="searchStartIndex@stgAdvConfigBean@servletRequest"
                           blockSize="<%= JspConstants.TS_BLOCK_SIZE %>">

                  <%-- Table Selection --%>
                  <uix:tableSelection>
                    <uix:multipleSelection shortDescBinding="SELECT_TABLESPACE@shrinkMsgs" selectedBinding="<%= JspConstants.SELECTED_ATTR %>"/>
                  </uix:tableSelection>

                  <%-- Tablespace column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="PROBCOL_TABLESPACE@msgs"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:contents>
                      <uix:styledText textBinding="tablespace"
                                      styleClass="OraTableCellText"/>
                    </uix:contents>
                  </uix:column>
                </uix:table>
              </uix:header>
            </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

