<%@ include file="/sdk/oemTop.jspf" %>

<%--
  -- Page:        grantPrivs.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.ConfigController
  --
  -- Description: Page for granting privileges to the monitor user
  --              so it has enough privs to run the wasted space check.
  --
  --  MODIFIED    (MM/DD/YY)
  --     qsong     09/01/05 - 4370005
  --     mnihalan  11/04/03 - Fix ADA issuse 
  --     jochen    10/03/03 - jochen_bug-3151778 
  --     jochen    09/25/03 - Initial entry
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.util.stgAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.stgAdv.StgAdvPages" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="loginMsgs"
            class="oracle.sysman.db.rsc.LoginResource"/>
<uix:bundle name="sdkMsgs"
            class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="foo"
               method="post"
               destination="/console/database/stgAdv/config"
               copyParams="target,type,cancelURL">
        <uix:formValue name="pageName"
                       value="<%= StgAdvPages.GRANT_PRIVS_PAGE %>"/>
        <uix:pageLayout titleBinding="pageHeader@stgAdvConfigBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%--              --%>
          <%-- Errors       --%>
          <%--              --%>
          <uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%--              --%>
          <%-- Buttons      --%>
          <%--              --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.GRANT_CANCEL %>" />
              <uix:submitButton textBinding="OK@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.GRANT_OK %>" />
            </uix:pageButtonBar>
          </uix:pageButtons>

          <%--                    --%>
          <%-- Instructional Text --%>
          <%--                    --%>
          <uix:pageStatus>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="grantPrivInstr@stgAdvConfigBean@servletRequest"/>
          </uix:pageStatus>

          <uix:contents>

            <%--                --%>
            <%-- login fields   --%>
            <%--                --%>
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:labeledFieldLayout width="70%">
                <uix:messageTextInput name="username"
                                      promptBinding="userName@loginMsgs"
                                      columns="30"
                                      textBinding="username@stgAdvConfigBean@servletRequest"
                                      noAutoComplete="true"
                                      required="uiOnly"/>
                <uix:messageTextInput name="password"
                                      promptBinding="password@loginMsgs"
                                      columns="30"
                                      textBinding="password@stgAdvConfigBean@servletRequest"
                                      required="uiOnly"
                                      noAutoComplete="true"
                                      secret="true"/>
                <uix:messageChoice name="role"
                                   promptBinding="role@loginMsgs"
                                   selectedValueBinding="role@stgAdvConfigBean@servletRequest"
                                   required="yes">
                  <uix:option text="Normal" value="normal"/>
                  <uix:option text="SYSOPER" value="sysoper"/>
                  <uix:option text="SYSDBA" value="sysdba"/>
                </uix:messageChoice>

              </uix:labeledFieldLayout>
            </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

