<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        perfConfig.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.ConfigController
  --
  -- Description: This page displays configuration options for storage
  --              problem metrics (performance problems)
  --
  --  MODIFIED    (MM/DD/YY)
  --     sshastry  03/20/06 - 
  --     mnihalan  07/01/04 - Fix label problems 
  --     jochen    04/26/04 - Add size limit
  --     mnihalan  11/04/03 - Fix ADA issuse
  --     jochen    10/17/03 - Move messages from temp file
  --     jochen    09/24/03 - Link to grant ANALYZE privs
  --     mnihalan  08/06/03 - UI review changes
  --     hsu       07/25/03 - change global
  --     jochen    08/05/03 - NLS
  --     jochen    06/12/03 - jochen_recommendations
  --     jochen    06/09/03 - Config for beta2
  --     jochen    04/29/03 - Config prototype
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.util.stgAdv.JspConstants" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="msgs"
            class="oracle.sysman.db.rsc.stgAdv.StgAdvMsg"/>
<uix:bundle name="sdkMsgs"
            class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="foo"
               method="post"
               destination="/console/database/stgAdv/config"
               copyParams="target,type,cancelURL">
        <uix:formValue name="pageName" value="/database/stgAdv/perfConfig"/>
        <uix:pageLayout titleBinding="pageHeader@stgAdvConfigBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%--              --%>
          <%-- Errors       --%>
          <%--              --%>
          <uix:messages>
            <uix:switcher childNameBinding="noPrivs@stgAdvConfigBean@servletRequest">
              <uix:case name="true">
                <uix:messageBox messageType="error"
                                messageBinding="NO_PRIVS@msgs">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraErrorText"
                                        textBinding="NO_PRIV_INSTR@msgs"/>
                        <uix:spacer height="3"/>
                      </uix:rowLayout>
                      <uix:spacer height="5"/>
                      <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">
                        <uix:styledText styleClass="OraErrorText"
                                        textBinding="RELATED_LINK@dbMsgs"/>
                        <uix:link destinationBinding="grantPrivsLink@stgAdvConfigBean@servletRequest"
                                  textBinding="CONFIGURE_USER@msgs"/>
                      </uix:labeledFieldLayout>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:messageBox>
              </uix:case>
              <uix:default>
                <oem:messageBox messageTypeBinding="msgType@servletRequest"
                                errorTableBinding="errors@servletRequest"
                                msgBundleBinding="StgAdvMsg@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
              </uix:default>
            </uix:switcher>
          </uix:messages>

          <%--              --%>
          <%-- Buttons      --%>
          <%--              --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.CANCEL %>" />
              <uix:submitButton textBinding="OK@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.OK %>" />
            </uix:pageButtonBar>
          </uix:pageButtons>

          <%--                    --%>
          <%-- Instructional Text --%>
          <%--                    --%>
          <uix:pageStatus>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="PERF_CONFIG_INSTR@msgs"/>
          </uix:pageStatus>

          <uix:contents>

            <uix:stackLayout>

              <%--                --%>
              <%-- Select Checks  --%>
              <%--                --%>
              <uix:header textBinding="PROBLEMS_TO_DETECT@msgs">
                <uix:stackLayout>
                  <uix:styledText textBinding="CONFIGURE_CHECKS_TIP@msgs"
                                  styleClass="OraInstructionText"/>
                                  
                  <uix:checkBox name="wasteCheckEnabled"
                                      textBinding="problemCheck@stgAdvConfigBean@servletRequest"
                                      checkedBinding="wasteCheckEnabled@stgAdvConfigBean@servletRequest"/>
              
                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:stackLayout renderedBinding="agentVerLT102@stgAdvConfigBean@servletRequest">
                    
                      <uix:styledText textBinding="WASTED_SPACE_TIP@msgs"
                                      styleClass="OraInlineInfoText"/>
                      <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">
                        <uix:messageTextInput name="wasteMin"
                                              promptBinding="wasteMin@msgs"
                                              textBinding="wasteMin@stgAdvConfigBean@servletRequest"
                                              columns="3"
                                              messageBinding="wasteMin@errors@servletRequest"
                                              messageTypeBinding="wasteMinMsgType@servletRequest"/>
                        <uix:messageTextInput renderedBinding="agentVerGT101@stgAdvConfigBean@servletRequest"
                                              name="minSegSize"
                                              promptBinding="minSegSize@msgs"
                                              columns="3"
                                              textBinding="minSegSize@stgAdvConfigBean@servletRequest"
                                              messageBinding="minSegSize@errors@servletRequest"
                                              messageTypeBinding="minSegSizeMsgType@servletRequest"/>
                      </uix:labeledFieldLayout>
                    </uix:stackLayout>
                     <uix:stackLayout renderedBinding="agentVerGT101@stgAdvConfigBean@servletRequest">
                      
                      <uix:styledText textBinding="RECLAIMABLE_SPACE_TIP@msgs"
                                      styleClass="OraInlineInfoText"/>
                      <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">
                        <uix:messageTextInput name="wasteMin"
                                              promptBinding="reclaimMin@msgs"
                                              textBinding="wasteMin@stgAdvConfigBean@servletRequest"
                                              columns="3"
                                              messageBinding="reclaimMin@errors@servletRequest"
                                              messageTypeBinding="wasteMinMsgType@servletRequest"/>
                        <uix:messageTextInput renderedBinding="agentVerGT101@stgAdvConfigBean@servletRequest"
                                              name="minSegSize"
                                              promptBinding="minReclaimSize@msgs"
                                              columns="3"
                                              textBinding="minSegSize@stgAdvConfigBean@servletRequest"
                                              messageBinding="minReclaimSize@errors@servletRequest"
                                              messageTypeBinding="minSegSizeMsgType@servletRequest"/>
                      </uix:labeledFieldLayout>
                    </uix:stackLayout>
                  </uix:rowLayout>

                  <uix:checkBox name="rowChainCheckEnabled"
                                textBinding="ROW_CHAIN_CHECK@msgs"
                                checkedBinding="rowChainCheckEnabled@stgAdvConfigBean@servletRequest"/>
                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                      <uix:stackLayout>
                        <uix:styledText textBinding="ROW_CHAIN_TIP@msgs"
                                        styleClass="OraInlineInfoText"/>
                        <uix:messageTextInput name="rowChainMin"
                                              promptBinding="rowChainMin@msgs"
                                              textBinding="rowChainMin@stgAdvConfigBean@servletRequest"
                                              columns="3"
                                              messageBinding="rowChainMin@errors@servletRequest"
                                              messageTypeBinding="rowChainMinMsgType@servletRequest">
                        </uix:messageTextInput>
                      </uix:stackLayout>
                    </uix:rowLayout>

                </uix:stackLayout>
              </uix:header>

              <%--                --%>
              <%-- Select Objects --%>
              <%--                --%>
              <uix:header textBinding="OBJECTS_TO_CHECK@msgs">
                <uix:stackLayout>
                  <uix:separator>
                    <uix:spacer height="2"/>
                  </uix:separator>

                    <uix:rowLayout width="80%">
                      <uix:styledText textBinding="OBJECTS_TIP@msgs"
                                      styleClass="OraInstructionText"/>
                      <uix:cellFormat hAlign="right"
                                      vAlign="bottom">
                        <uix:submitButton textBinding="ADD@sdkMsgs"
                                          name="event"
                                          value="<%= JspConstants.ADD_TABLESPACE %>" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:table name="perfObjects"
                               alternateTextBinding="NO_OBJECTS@msgs"
                               formSubmitted="true"
                               width="80%"
                               summaryBinding="OBJECTS_TO_CHECK@msgs"
                               tableDataBinding="selectedTablespaces@stgAdvConfigBean@servletRequest"
                               minValue="1"
                               maxValueBinding="tablespaceCount@stgAdvConfigBean@servletRequest"
                               valueBinding="selTablespaceStartIndex@stgAdvConfigBean@servletRequest"
                               blockSize="<%= JspConstants.TS_BLOCK_SIZE %>">
                      <%-- Table Selection --%>
                      <uix:tableSelection>
                        <uix:multipleSelection selectedBinding="<%= JspConstants.SELECTED_ATTR %>"
                                              shortDescBinding="SELECT_REMOVE@msgs">
                          <uix:pageButtonBar>
                            <uix:submitButton textBinding="REMOVE@sdkMsgs"
                                              name="event"
                                              value="<%= JspConstants.REMOVE %>" />
                          </uix:pageButtonBar>
                        </uix:multipleSelection>
                      </uix:tableSelection>
                      <%-- Tablespace column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="PROBCOL_TABLESPACE@msgs"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="tablespace"/>
                        </uix:contents>
                      </uix:column>
                    </uix:table>

                </uix:stackLayout>
              </uix:header>
            </uix:stackLayout>

            <uix:spacer width="10"/>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

