<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        problems.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.ProblemsController
  --
  -- Description: This is the page that displays
  --              the Fragmentation Issues page from the db sitemap
  --
  --  MODIFIED    (MM/DD/YY)
  --     kmckeen   07/01/05 - Add support for pageMsgBox 
  --     mnihalan  10/12/04 - Change layout of columns 
  --     mnihalan  08/05/04 - Add tabs 
  --     mnihalan  07/01/04 - Fix label problems 
  --     mnihalan  05/05/04 - Fix demo issues 
  --     jochen    01/22/04 - Allow recommendations to be sorted
  --     mnihalan  11/04/03 - Fix ADA issuse
  --     jochen    10/17/03 - Disable rather than remove Shrink button if not
  --     jochen    10/10/03 - Don't show instructions if no recommendations
  --     mnihalan  09/10/03 - Add sorting
  --     jochen    08/26/03 - Only show Shrink/Reorg buttons if applicable
  --                          segments exist.  Make table multiselect
  --     jochen    08/13/03 - Shrink multiple
  --     mnihalan  08/06/03 - UI review changes
  --     hsu       07/25/03 - change global
  --     jochen    06/09/03 - Add configuration info
  --     jochen    05/27/03 - Recommendations column change
  --     jochen    05/15/03 - Spacing
  --     qsong     04/29/03 - Add oemTop.jspf
  --     jochen    04/01/03 - jochen_metric
  --     jochen    03/26/03 - Show objects with wasted space - prototype
  --     mnihalan  02/11/03 - Initial creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.util.stgAdv.JspConstants" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="msgs"
            class="oracle.sysman.db.rsc.stgAdv.StgAdvMsg"/>
<uix:bundle name="mntrResourceBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>
<uix:bundle name="commonResourceBundle"
            class="oracle.sysman.resources.CommonResourceBundle"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo"
               method="post"
               destination="/console/database/stgAdv/problems"
               copyParams="target,type,cancelURL">
        <uix:formValue name="pageName" value="/database/stgAdv/perfProblems"/>
        <uix:pageLayout titleBinding="pageHeader@stgAdvProblemsBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%--              --%>
          <%-- Errors       --%>
          <%--              --%>
           <uix:messages>
            <oem:messageBox messageTypeBinding="msgType@servletRequest"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%--                                                          --%>
          <%-- Support pageMsgBox for any apps that return to this page --%>
          <%-- and support it.  This include must be positioned AFTER   --%>
          <%-- any other uix:messages or messageBox tags.               --%>
          <%--                                                          --%>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>

          <uix:contents>
            <uix:stackLayout>
                <uix:tableLayout width="100%">
                    <uix:rowLayout>
                        <%-- Key Notation for HWM --%>
                        <uix:cellFormat vAlign="top" hAlign="left">
                            <uix:tableLayout>
                                <uix:rowLayout hAlign="left">
                                   <uix:cellFormat wrappingDisabled="true">
                                       <uix:styledText styleClass="OraTipText"
                                          textBinding="HWM_NOTATION@msgs"/>
                                   </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                        </uix:cellFormat>
                        <%-- Timestamp for last time page refreshed --%>
                        <uix:cellFormat vAlign="top" hAlign="right">
                        <%-- need tableLayout for Netscape --%>
                        <uix:tableLayout>
                            <uix:rowLayout hAlign="right">
                            <uix:cellFormat wrappingDisabled="true">
                                <uix:styledText styleClass="OraTipText"
                                            textBinding="PAGE_REFRESHED@mntrResourceBundle"/>
                            </uix:cellFormat>
                            <uix:spacer width="4"/>
                            <uix:cellFormat wrappingDisabled="true">
                                <uix:styledText styleClass="OraTipLabel"
                                            textBinding="refreshTimestamp@stgAdvProblemsBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="4"/>
                            <uix:cellFormat wrappingDisabled="true">
                            <uix:image source="/em/images/refresh.gif"
                                     destinationBinding="destination@stgAdvProblemsBean@servletRequest"
                                     shortDescBinding="REFRESH_DATA@commonResourceBundle"/>
                            </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                </uix:tableLayout>
                
                     <uix:tableLayout width="100%">
                        <uix:rowLayout renderedBinding="displayCollectionTimestamp@stgAdvProblemsBean@servletRequest">
                            <%-- Timestamp for last time data collected from agent --%>
                            <uix:cellFormat vAlign="top" hAlign="right">
                            <%-- need tableLayout for Netscape --%>
                            <uix:tableLayout>
                                <uix:rowLayout hAlign="right">
                                <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraTipText"
                                                textBinding="COLLECTED_FROM_TARGET@mntrResourceBundle"/>
                                </uix:cellFormat>
                                <uix:spacer width="4"/>
                                <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraTipLabel"
                                                textBinding="lastCollectionTimestamp@stgAdvProblemsBean@servletRequest"/>
                                </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                    <uix:header textBinding="CONFIG_HDR@msgs">
                    <uix:switcher childNameBinding="agentDataAvailable@stgAdvConfigBean@servletRequest">
                      <uix:case name="true">
                        <uix:stackLayout renderedBinding="agentDataAvailable@stgAdvConfigBean@servletRequest">
                         
                          <uix:rowLayout width="100%">
                              <uix:labeledFieldLayout width="100%">
                              
                                  <uix:messageStyledText renderedBinding="anyCheckEnabled@stgAdvConfigBean@servletRequest"
                                                       promptBinding="NUM_TABLESPACES@msgs"
                                                       textBinding="tablespaceCount@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
                              </uix:labeledFieldLayout>
                              <uix:cellFormat hAlign="right">
                                  <uix:submitButton textBinding="CONFIGURE@msgs"
                                                    name="event"
                                                    value="<%= JspConstants.CONFIGURE %>"/>
                              </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                              <uix:header textBinding="spaceCheckHdr@stgAdvConfigBean@servletRequest">
                                <uix:labeledFieldLayout width="75%">
                                  <uix:styledText textBinding="WASTED_SPACE_ENABLED@msgs"
                                                styleClass="OraFieldText"/>
                                   <uix:styledText textBinding="checkWasteMsg@stgAdvConfigBean@servletRequest"
                                                styleClass="OraDataText"/>
                                  <uix:messageStyledText renderedBinding="checkWaste@stgAdvConfigBean@servletRequest"
                                                       promptBinding="spaceCheckPct@stgAdvConfigBean@servletRequest"
                                                       textBinding="wasteMin@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
                                  <uix:messageStyledText renderedBinding="checkWasteAndAgentVerGT101@stgAdvConfigBean@servletRequest"
                                                       promptBinding="spaceCheckMB@stgAdvConfigBean@servletRequest"
                                                       textBinding="minSegSize@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
                                </uix:labeledFieldLayout>
                              </uix:header>
                            </uix:contents>
                          </uix:cellFormat>
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                               <%-- Degree --%>
                              <uix:header textBinding="ROWCHAIN_HDR@msgs">
                                <uix:labeledFieldLayout width="75%">
                                  <uix:styledText textBinding="ROWCHAIN_ENABLED@msgs"
                                                styleClass="OraFieldText"/>
                                  <uix:styledText textBinding="checkRowChainMsg@stgAdvConfigBean@servletRequest"
                                                styleClass="OraDataText"/>
                                  
                                  <uix:messageStyledText renderedBinding="checkRowChain@stgAdvConfigBean@servletRequest"
                                                       promptBinding="rowChainMin@msgs"
                                                       textBinding="rowChainMin@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
    
                               </uix:labeledFieldLayout>		
                              </uix:header>
                            </uix:contents>
                          </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:stackLayout>
                      </uix:case>
                      <uix:default>
                        <uix:styledText textBinding="UNKNOWN@msgs"
                                        styleClass="OraErrorText"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:header>
                
                  <uix:subTabLayout>
                          <%-- SubTabs --%>
                          <uix:subTabs>
                            <jsp:include page="/database/stgAdv/subTabInclude.jsp" />
                            <uix:ref refID="subTabInclude" />
                          </uix:subTabs>
                                  <uix:stackLayout>
                                       <uix:switcher childNameBinding="instanceVersion_gte10@stgAdvConfigBean@servletRequest">
                                            <uix:case name="true">
                                                <uix:styledText textBinding="MULTIPLE_INSTR@msgs"
                                                          styleClass="OraInstructionText"
                                                          renderedBinding="hasRecommendations@stgAdvProblemsBean@servletRequest"/>
                                           </uix:case>
                                           <uix:default>
                                                <uix:styledText textBinding="MULTIPLE_INSTR_PRE10G@msgs"
                                                          styleClass="OraInstructionText"
                                                          renderedBinding="hasRecommendations@stgAdvProblemsBean@servletRequest"/>
                                           </uix:default>
                                      </uix:switcher>
                                      <uix:spacer height="5"/>
                                      <uix:table name="tableList"
                                                   alternateTextBinding="NO_PROBLEMS@msgs"
                                                   formSubmitted="true"
                                                   width="100%"
                                                   tableDataBinding="rowData@stgAdvProblemsBean@servletRequest"
                                                   minValue="1"
                                                   summaryBinding="STG_PERF@dbMsgs"
                                                   maxValueBinding="numRows@stgAdvProblemsBean@servletRequest"
                                                   valueBinding="startIndex@stgAdvProblemsBean@servletRequest"
                                                   blockSize="<%= JspConstants.PROBLEMS_BLOCK_SIZE %>">
                        
                                            <%-- Table Selection --%>
                                            <uix:tableSelection>
                                              <uix:multipleSelection selectedBinding="<%= JspConstants.SELECTED_ATTR %>"
                                                                     shortDescBinding="SELECT_REMOVE@msgs">
                                              <uix:pageButtonBar>
                                                <uix:submitButton textBinding="SHRINK_MULTIPLE@msgs"
                                                                  name="event"
                                                                  value="<%= JspConstants.SHRINK %>"
                                                                  renderedBinding="instanceVersion_gte10@stgAdvConfigBean@servletRequest"
                                                                  disabledBinding="noShrinkableObjects@stgAdvProblemsBean@servletRequest"/>
                                                <uix:submitButton textBinding="REORG_MULTIPLE@msgs"
                                                                  name="event"
                                                                  value="<%= JspConstants.REORG %>"
                                                                  disabledBinding="noReorgableObjects@stgAdvProblemsBean@servletRequest"/>
                                              </uix:pageButtonBar>
                                              </uix:multipleSelection>
                                            </uix:tableSelection>
                        
                      
                        
                                          <%-- Table column Schema Name column --%>
                                          <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="PROBCOL_SCHEMA@msgs" sortableBinding="sortSchema@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.SCHEMA_NAME_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                        
                                          <%-- Table column Segment --%>
                                          <uix:column>
                                           <uix:columnHeader>
                                                <uix:sortableHeader textBinding="PROBCOL_OBJECT@msgs" sortableBinding="sortSegment@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.SEGMENT_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                        
                                          
                                          <%-- TotalSpace --%>
                                          <uix:column>
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="probColTotalSpaceHdr@stgAdvConfigBean@servletRequest"
                                                                  sortableBinding="sortTotalSpace@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.TOTAL_SPACE_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                          <%-- UsedSpace for 10.2 or greater agents--%>
                                          <uix:column renderedBinding="agentVerGT101@stgAdvConfigBean@servletRequest">
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="PROBCOL_USED_SPACE@msgs"
                                                                  sortableBinding="sortUsedSpace@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.USED_SPACE_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                          <%-- Reclaimable Space for 10.2 or greater agents--%>
                                           <uix:column renderedBinding="agentVerGT101@stgAdvConfigBean@servletRequest">
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PROBCOL_RECLAIMABLE_SPACE@msgs"
                                                                          sortableBinding="sortReclaimableSpace@stgAdvProblemsBean@servletRequest"/>
                                                </uix:columnHeader>
                                                <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                                <uix:contents>
                                                    <uix:styledText textBinding="<%= JspConstants.RECLAIMABLE_SPACE_ATTR %>"/>
                                                </uix:contents>
                                            </uix:column>
                                          
                                            <%-- Table column Reclaimable Space(%) for 10.2 or greater agents--%>
                                            <uix:column renderedBinding="agentVerGT101@stgAdvConfigBean@servletRequest">
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PROBCOL_RECLAIMABLE_SPACE_PERCENTAGE@msgs"
                                                                          sortableBinding="sortReclaimableSpacePercentage@stgAdvProblemsBean@servletRequest"/>
                                                </uix:columnHeader>
                                                <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                                <uix:contents>
                                                    <uix:styledText textBinding="<%= JspConstants.RECLAIMABLE_SPACE_PERCENTAGE_ATTR %>"/>
                                                </uix:contents>
                                            </uix:column>
                                           
                                         
                                            <%-- Table column Unused Space(MB) for pre 10.2 agents--%>
                                            <uix:column renderedBinding="agentVerLT102@stgAdvConfigBean@servletRequest">
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PROBCOL_WASTED_SPACE@msgs"
                                                                          sortableBinding="sortWastedSpace@stgAdvProblemsBean@servletRequest"/>
                                                </uix:columnHeader>
                                                <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                                <uix:contents>
                                                  <uix:styledText textBinding="<%= JspConstants.WASTED_SPACE_ATTR %>"/>
                                                </uix:contents>
                                            </uix:column>
                                             
                                             <%-- Table column Unused Space(%) for pre 10.2 agents--%>   
                                              <uix:column renderedBinding="agentVerLT102@stgAdvConfigBean@servletRequest">
                                                  <uix:columnHeader>
                                                      <uix:sortableHeader textBinding="PROBCOL_WASTED_SPACE_PERCENTAGE@msgs"
                                                                          sortableBinding="sortWastedSpacePercentage@stgAdvProblemsBean@servletRequest"/>
                                                  </uix:columnHeader>
                                                  <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                                  <uix:contents>
                                                      <uix:styledText textBinding="<%= JspConstants.WASTED_SPACE_PERCENTAGE_ATTR %>"/>
                                                    </uix:contents>
                                            </uix:column>
                                              
                                                  
                                          
                                          <%-- Table column Total Rows --%>
                                          <uix:column>
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="PROBCOL_TOTAL_ROWS@msgs"
                                                                  sortableBinding="sortTotalRows@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.TOTAL_ROWS_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                          <%-- Table column Row Chaining(%) --%>
                                          <uix:column>
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="PROBCOL_ROW_CHAINING@msgs"
                                                                  sortableBinding="sortRowChaining@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.ROW_CHAINING_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                          <%-- Table column recommendation --%>
                                          <uix:column renderedBinding="instanceVersion_gte10@stgAdvConfigBean@servletRequest">
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="PROBCOL_RECOMMENDATION@msgs"
                                                                  sortableBinding="sortRecommendations@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:button textBinding="<%= JspConstants.REC_TEXT_ATTR %>"
                                                      destinationBinding="<%= JspConstants.REC_LINK_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                            <%-- Table column Tablespace column --%>
                                          <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader sortableBinding="sortTablespace@stgAdvProblemsBean@servletRequest" textBinding="PROBCOL_TABLESPACE@msgs" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.TABLESPACE_NAME_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                          <%-- Table column segment type --%>
                                          <uix:column>
                                             <uix:columnHeader>
                                                <uix:sortableHeader textBinding="PROBCOL_OBJECT_TYPE@msgs" sortableBinding="sortSegmentType@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.SEGMENT_TYPE_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                          
                                          <%-- Table column recommendation --%>
                                          <%--<uix:column>
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="PROBCOL_RECOMMENDATION@msgs"
                                                                  sortableBinding="sortRecommendations@stgAdvProblemsBean@servletRequest"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:contents>
                                              <uix:include nodeBinding="<%= JspConstants.RECOMMENDATION_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                        
                                          <%-- Table column timestamp --%>
                                          <%--<uix:column>
                                            <uix:columnHeader>
                                              <uix:styledText textBinding="PROBCOL_TIMESTAMP@msgs"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:contents>
                                              <uix:styledText textBinding="<%= JspConstants.TIMESTAMP_ATTR %>"/>
                                            </uix:contents>
                                          </uix:column>
                                         --%>
                        
                                          <%-- ***** Test column *******
                                              This column simulates the formatting returned by the
                                              UINode generated in the bean for the recommendations
                                              column.  Uncomment this to play with the formatting.
                                              You have to comment out the real recommendations column
                                              to do tests, or it will affect the layout in the table.
                                              ************************
                                          <uix:column>
                                            <uix:columnHeader>
                                              <uix:styledText textBinding="PROBCOL_RECOMMENDATION@msgs"/>
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:contents>
                                              <uix:stackLayout>
                                                <uix:separator>
                                                  <uix:spacer height="1" width="1"/>
                                                </uix:separator>
                                                <uix:contents>
                                                  <uix:rowLayout>
                                                    <uix:cellFormat vAlign="top">
                                                      <uix:image source="/em/images/warning.gif"/>
                                                    </uix:cellFormat>
                                                    <uix:spacer width="2"/>
                                                    <uix:styledText text="lots of wasted space"/>
                                                  </uix:rowLayout>
                                                  <uix:rowLayout>
                                                    <uix:spacer width="20" height="1"/>
                                                    <uix:link text="shrink"
                                                              destination="tbd"/>
                                                  </uix:rowLayout>
                                                  <uix:rowLayout>
                                                    <uix:spacer width="20" height="1"/>
                                                    <uix:link text="or reorganize"
                                                              destination="tbd"/>
                                                  </uix:rowLayout>
                                                </uix:contents>
                                              </uix:stackLayout>
                                            </uix:contents>
                                          </uix:column>
                        
                          --%>
                                        </uix:table>
                                  </uix:stackLayout>
                      </uix:subTabLayout>
            </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
