<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        perfProblemsTbsp.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.ProblemsController
  --
  -- Description: Tablespace Summary tab for Fragmentation Issues page
  --
  --  MODIFIED    (MM/DD/YY)
  --     mnihalan  06/29/05 - Add columns 
  --     mnihalan  08/18/04 - mnihalan_seg_adv25
  --     mnihalan  08/05/04 - Initial creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.util.stgAdv.JspConstants" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="msgs"
            class="oracle.sysman.db.rsc.stgAdv.StgAdvMsg"/>
<uix:bundle name="mntrResourceBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>
<uix:bundle name="commonResourceBundle"
            class="oracle.sysman.resources.CommonResourceBundle"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo"
               method="post"
               destination="/console/database/stgAdv/problems"
               copyParams="target,type,cancelURL">
        <uix:formValue name="pageName" value="/database/stgAdv/perfProblemsTbsp"/>
        <uix:pageLayout titleBinding="pageHeader@stgAdvProblemsBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%--              --%>
          <%-- Errors       --%>
          <%--              --%>
           <uix:messages>
            <oem:messageBox messageTypeBinding="msgType@servletRequest"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>


          <uix:contents>
            <uix:stackLayout>
                <uix:tableLayout width="100%">
                    <uix:rowLayout>
                        <%-- Key Notation for HWM --%>
                        <uix:cellFormat vAlign="top" hAlign="left">
                            <uix:tableLayout>
                                <uix:rowLayout hAlign="left">
                                   <uix:cellFormat wrappingDisabled="true">
                                       <uix:styledText styleClass="OraTipText"
                                          textBinding="HWM_NOTATION@msgs"/>
                                   </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                        </uix:cellFormat>
                        <%-- Timestamp for last time page refreshed --%>
                        <uix:cellFormat vAlign="top" hAlign="right">
                        <%-- need tableLayout for Netscape --%>
                        <uix:tableLayout>
                            <uix:rowLayout hAlign="right">
                            <uix:cellFormat wrappingDisabled="true">
                                <uix:styledText styleClass="OraTipText"
                                            textBinding="PAGE_REFRESHED@mntrResourceBundle"/>
                            </uix:cellFormat>
                            <uix:spacer width="4"/>
                            <uix:cellFormat wrappingDisabled="true">
                                <uix:styledText styleClass="OraTipLabel"
                                            textBinding="refreshTimestamp@stgAdvProblemsBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="4"/>
                            <uix:cellFormat wrappingDisabled="true">
                            <uix:image source="/em/images/refresh.gif"
                                     destinationBinding="destination@stgAdvProblemsBean@servletRequest"
                                     shortDescBinding="REFRESH_DATA@commonResourceBundle"/>
                            </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                </uix:tableLayout>
                
                     <uix:tableLayout width="100%">
                        <uix:rowLayout renderedBinding="displayCollectionTimestamp@stgAdvProblemsBean@servletRequest">
                            <%-- Timestamp for last time data collected from agent --%>
                            <uix:cellFormat vAlign="top" hAlign="right">
                            <%-- need tableLayout for Netscape --%>
                            <uix:tableLayout>
                                <uix:rowLayout hAlign="right">
                                <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraTipText"
                                                textBinding="COLLECTED_FROM_TARGET@mntrResourceBundle"/>
                                </uix:cellFormat>
                                <uix:spacer width="4"/>
                                <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraTipLabel"
                                                textBinding="lastCollectionTimestamp@stgAdvProblemsBean@servletRequest"/>
                                </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                    <uix:header textBinding="CONFIG_HDR@msgs">
                    <uix:switcher childNameBinding="agentDataAvailable@stgAdvConfigBean@servletRequest">
                      <uix:case name="true">
                        <uix:stackLayout renderedBinding="agentDataAvailable@stgAdvConfigBean@servletRequest">
                         
                          <uix:rowLayout width="100%">
                              <uix:labeledFieldLayout width="100%">
                              
                                  <uix:messageStyledText renderedBinding="anyCheckEnabled@stgAdvConfigBean@servletRequest"
                                                       promptBinding="NUM_TABLESPACES@msgs"
                                                       textBinding="tablespaceCount@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
                              </uix:labeledFieldLayout>
                              <uix:cellFormat hAlign="right">
                                  <uix:submitButton textBinding="CONFIGURE@msgs"
                                                    name="event"
                                                    value="<%= JspConstants.CONFIGURE %>"/>
                              </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                              <uix:header textBinding="spaceCheckHdr@stgAdvConfigBean@servletRequest">
                                <uix:labeledFieldLayout width="75%">
                                  <uix:styledText textBinding="WASTED_SPACE_ENABLED@msgs"
                                                styleClass="OraFieldText"/>
                                   <uix:styledText textBinding="checkWasteMsg@stgAdvConfigBean@servletRequest"
                                                styleClass="OraDataText"/>
                                  <uix:messageStyledText renderedBinding="checkWaste@stgAdvConfigBean@servletRequest"
                                                       promptBinding="spaceCheckPct@stgAdvConfigBean@servletRequest"
                                                       textBinding="wasteMin@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
                                  <uix:messageStyledText renderedBinding="checkWasteAndAgentVerGT101@stgAdvConfigBean@servletRequest"
                                                       promptBinding="spaceCheckMB@stgAdvConfigBean@servletRequest"
                                                       textBinding="minSegSize@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
                                </uix:labeledFieldLayout>
                              </uix:header>
                            </uix:contents>
                          </uix:cellFormat>
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                               <%-- Degree --%>
                              <uix:header textBinding="ROWCHAIN_HDR@msgs">
                                <uix:labeledFieldLayout width="75%">
                                  <uix:styledText textBinding="ROWCHAIN_ENABLED@msgs"
                                                styleClass="OraFieldText"/>
                                  <uix:styledText textBinding="checkRowChainMsg@stgAdvConfigBean@servletRequest"
                                                styleClass="OraDataText"/>
                                  
                                  <uix:messageStyledText renderedBinding="checkRowChain@stgAdvConfigBean@servletRequest"
                                                       promptBinding="rowChainMin@msgs"
                                                       textBinding="rowChainMin@stgAdvConfigBean@servletRequest"
                                                       styleClass="OraDataText"/>
    
                               </uix:labeledFieldLayout>		
                              </uix:header>
                            </uix:contents>
                          </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:stackLayout>
                      </uix:case>
                      <uix:default>
                        <uix:styledText textBinding="UNKNOWN@msgs"
                                        styleClass="OraErrorText"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:header>
                  
                   <uix:subTabLayout>
                          <%-- SubTabs --%>
                          <uix:subTabs>
                            <jsp:include page="/database/stgAdv/subTabInclude.jsp" />
                            <uix:ref refID="subTabInclude" />
                          </uix:subTabs>
                                <uix:stackLayout>
                                       <uix:switcher childNameBinding="instanceVersion_gte10@stgAdvConfigBean@servletRequest">
                                            <uix:case name="true">
                                                <uix:styledText textBinding="MULTIPLE_INSTR_TBSP@msgs"
                                                          styleClass="OraInstructionText"
                                                          renderedBinding="hasRecommendations@stgAdvProblemsBean@servletRequest"/>
                                           </uix:case>
                                           <uix:default>
                                                <uix:styledText textBinding="MULTIPLE_INSTR_TBSP_PRE10G@msgs"
                                                          styleClass="OraInstructionText"
                                                          renderedBinding="hasRecommendations@stgAdvProblemsBean@servletRequest"/>
                                           </uix:default>
                                      </uix:switcher>
                                      <uix:spacer height="5"/>
                                 <uix:table name="tablespaceList"
                                           alternateTextBinding="NO_PROBLEMS@msgs"
                                           formSubmitted="true"
                                           width="50%"
                                           tableDataBinding="rowData@stgAdvTablespaceBean@servletRequest"
                                           minValue="1"
                                           summaryBinding="STG_PERF@dbMsgs"
                                           maxValueBinding="numRows@stgAdvTablespaceBean@servletRequest"
                                           valueBinding="startIndex@stgAdvTablespaceBean@servletRequest"
                                           blockSize="<%= JspConstants.TS_BLOCK_SIZE %>">
                
                
                                  <%-- Table column Tablespace column --%>
                                  <uix:column>
                                    <uix:columnHeader>
                                        <uix:sortableHeader sortableBinding="sortTablespace@stgAdvTablespaceBean@servletRequest" textBinding="PROBCOL_TABLESPACE@msgs" />
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="textFormat"/>
                                    <uix:contents>
                                      <uix:styledText textBinding="<%= JspConstants.TABLESPACE_NAME_ATTR %>"/>
                                    </uix:contents>
                                  </uix:column>
                                  
                                     <%-- Table column Tablespace Size --%>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:sortableHeader textBinding="TBSP_SIZE@msgs"
                                                          sortableBinding="sortTablespaceSize@stgAdvTablespaceBean@servletRequest"/>
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="numberFormat"/>
                                    <uix:contents>
                                      <uix:styledText textBinding="<%= JspConstants.TABLESPACE_SIZE_ATTR %>"/>
                                    </uix:contents>
                                  </uix:column>
                                  
                
                                   <%-- Table column Wasted Space(MB) --%>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:sortableHeader textBinding="probColSpaceHdr@stgAdvConfigBean@servletRequest"
                                                          sortableBinding="sortWastedSpace@stgAdvTablespaceBean@servletRequest"/>
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="numberFormat"/>
                                    <uix:contents>
                                      <uix:styledText textBinding="<%= JspConstants.WASTED_SPACE_ATTR %>"/>
                                    </uix:contents>
                                  </uix:column>
                                  
                                  <%-- Table column Extent Mgmt --%>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:sortableHeader textBinding="EXTENT_MGMT@msgs"
                                                          sortableBinding="sortExtMgmt@stgAdvTablespaceBean@servletRequest"/>
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="textFormat"/>
                                    <uix:contents>
                                      <uix:styledText textBinding="<%= JspConstants.EXTENT_MGMT_ATTR %>"/>
                                    </uix:contents>
                                  </uix:column>
                                  
                                  
                                  <%-- Table segment space Mgmt --%>
                                  <uix:column renderedBinding="agentVerGT101@stgConfigBean@servletRequest">
                                    <uix:columnHeader>
                                      <uix:sortableHeader textBinding="SEG_MGMT@msgs"
                                                          sortableBinding="sortSegSpaceMgmt@stgAdvTablespaceBean@servletRequest"/>
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="textFormat"/>
                                    <uix:contents>
                                      <uix:styledText textBinding="<%= JspConstants.SEG_SPACE_MGMT_ATTR %>"/>
                                    </uix:contents>
                                  </uix:column>
                                  
                                   <%-- Table column Recommendation Action--%>
                                  <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="PROBCOL_RECOMMENDATION@msgs" sortableBinding="sortRecommendations@stgAdvTablespaceBean@servletRequest"/>
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>                    
                                      <uix:contents>
                                           <uix:button textBinding="<%= JspConstants.RECOMMENDATION_ATTR %>"
                                                destinationBinding="<%= JspConstants.REC_DEST_LINK_ATTR %>"/>
                                      </uix:contents>
                                  </uix:column>
                                  
                                </uix:table>
                        </uix:stackLayout>
                </uix:subTabLayout>
                              
            </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
