<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_VIEW@ArchivelogBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="archiveViewForm" 
        method="get"
        destination="/console/database/storage/archivelog" copyParams="target,type,cancelURL,otype,oname">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/archivelog/pageView"/>

        <uix:pageLayout titleBinding="TITLE_VIEW@ArchivelogBundle@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <%---------------------------------------------%>
          <%---           Label/Field Pairs           ---%>             
          <%---------------------------------------------%>
          <uix:tableLayout cellSpacing="5">

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_NAME@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="name@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_SEQUENCE_NUM@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="sequenceNum@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_SIZE@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="size@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_ARCHIVAL_TIME@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="archivalTime@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_FIRST_CHANGE_NUM@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="firstChangeNum@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_FIRST_CHANGE_TIME@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="firstChangeTime@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_LAST_CHANGE_NUM@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="lastChangeNum@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="LBL_LAST_CHANGE_TIME@ArchivelogBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="lastChangeTime@defaultBean@servletRequest"
                  />
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:tableLayout>

          <%---------------------------------------------%>
          <%---              Page Buttons             ---%>             
          <%---------------------------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                textBinding="OK@uixDBObjectBundle@servletRequest"
                name="event" value="cancel"/>  

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
